# Orphaned Doc Comment

A doc comment should be attached to a declaration

## Non Triggering Examples

```swift
/// My great property
var myGreatProperty: String!
```

```swift
//////////////////////////////////////
//
// Copyright header.
//
//////////////////////////////////////
```

```swift
/// Look here for more info: https://github.com.
var myGreatProperty: String!
```

```swift
/// Look here for more info:
/// https://github.com.
var myGreatProperty: String!
```

## Triggering Examples

```swift
↓/// My great property
// Not a doc string
var myGreatProperty: String!
```

```swift
↓/// Look here for more info: https://github.com.
// Not a doc string
var myGreatProperty: String!
```

```swift
↓/// Look here for more info: https://github.com.


// Not a doc string
var myGreatProperty: String!
```

```swift
↓/// Look here for more info: https://github.com.
// Not a doc string
↓/// My great property
// Not a doc string
var myGreatProperty: String!
```

```swift
extension Nested {
    ↓///
    /// Look here for more info: https://github.com.

    // Not a doc string
    var myGreatProperty: String!
}
```