# Private SwiftUI State Properties

SwiftUI state properties should be private

## Non Triggering Examples

```swift
struct MyApp: App {
    @State private var isPlaying: Bool = false
}
```

```swift
struct MyScene: Scene {
    @State private var isPlaying: Bool = false
}
```

```swift
struct CofntentView: View {
    @State private var isPlaying: Bool = false
}
```

```swift
struct ContentView: View {
    @State private var isPlaying: Bool = false

    struct InnerView: View {
        @State private var showsIndicator: Bool = false
    }
}
```

```swift
struct MyStruct {
    struct ContentView: View {
        @State private var isPlaying: Bool = false
    }
}
```

```swift
struct MyStruct {
    struct ContentView: View {
        @State private var isPlaying: Bool = false
    }

    @State var nonTriggeringState: Bool = false
}
```

```swift
struct ContentView: View {
    var s: Int {
        @State
        var s: Int = 3
        return s
    }

    var body: some View { Text("") }
}
```

```swift
struct ContentView: View {
    var isPlaying = false
}
```

```swift
struct MyApp: App {
    @StateObject private var model = DataModel()
}
```

```swift
struct MyScene: Scene {
    @StateObject private var model = DataModel()
}
```

```swift
struct ContentView: View {
    @StateObject private var model = DataModel()
}
```

```swift
struct MyStruct {
    struct ContentView: View {
        @StateObject private var dataModel = DataModel()
    }

    @StateObject var nonTriggeringObject = MyModel()
}
```

```swift
struct Foo {
    @State var bar = false
}
```

```swift
class Foo: ObservableObject {
    @State var bar = Bar()
}
```

```swift
extension MyObject {
    struct ContentView: View {
        @State private var isPlaying: Bool = false
    }
}
```

```swift
actor ContentView: View {
    @State private var isPlaying: Bool = false
}
```

```swift
struct ContentViewModifier: ViewModifier {
    @State private var isPlaying = false
}
```

## Triggering Examples

```swift
struct MyApp: App {
    @State ↓var isPlaying: Bool = false
}
```

```swift
struct MyScene: Scene {
    @State ↓public var isPlaying: Bool = false
}
```

```swift
struct ContentView: View {
    @State ↓var isPlaying: Bool = false
}
```

```swift
struct ContentView: View {
    struct InnerView: View {
        @State private var showsIndicator: Bool = false
    }

    @State ↓var isPlaying: Bool = false
}
```

```swift
struct MyStruct {
    struct ContentView: View {
        @State ↓var isPlaying: Bool = false
    }
}
```

```swift
struct MyStruct {
    struct ContentView: View {
        @State ↓var isPlaying: Bool = false
    }

    @State var isPlaying: Bool = false
}
```

```swift
final class ContentView: View {
    @State ↓var isPlaying: Bool = false
}
```

```swift
extension MyObject {
    struct ContentView: View {
        @State ↓var isPlaying: Bool = false
    }
}
```

```swift
actor ContentView: View {
    @State ↓var isPlaying: Bool = false
}
```

```swift
struct MyApp: App {
    @StateObject ↓var model = DataModel()
}
```

```swift
struct MyScene: Scene {
    @StateObject ↓var model = DataModel()
}
```

```swift
struct ContentView: View {
    @StateObject ↓var model = DataModel()
}
```

```swift
struct ContentView: View {
    @State ↓private(set) var isPlaying = false
```

```swift
struct ContentView: View {
    @State ↓fileprivate(set) public var isPlaying = false
```

```swift
struct ContentViewModifier: ViewModifier {
    @State ↓var isPlaying = false
}
```