# Prohibited Interface Builder

Creating views using Interface Builder should be avoided

## Non Triggering Examples

```swift
class ViewController: UIViewController {
    var label: UILabel!
}
```

```swift
class ViewController: UIViewController {
    @objc func buttonTapped(_ sender: UIButton) {}
}
```

## Triggering Examples

```swift
class ViewController: UIViewController {
    @IBOutlet ↓var label: UILabel!
}
```

```swift
class ViewController: UIViewController {
    @IBAction ↓func buttonTapped(_ sender: UIButton) {}
}
```