# Reduce Boolean

Prefer using `.allSatisfy()` or `.contains()` over `reduce(true)` or `reduce(false)`.

## Non Triggering Examples

```swift
nums.reduce(0) { $0.0 + $0.1 }
```

```swift
nums.reduce(0.0) { $0.0 + $0.1 }
```

```swift
nums.reduce(initial: true) { $0.0 && $0.1 == 3 }
```

## Triggering Examples

```swift
let allNines = nums.↓reduce(true) { $0.0 && $0.1 == 9 }
```

```swift
let anyNines = nums.↓reduce(false) { $0.0 || $0.1 == 9 }
```

```swift
let allValid = validators.↓reduce(true) { $0 && $1(input) }
```

```swift
let anyValid = validators.↓reduce(false) { $0 || $1(input) }
```

```swift
let allNines = nums.↓reduce(true, { $0.0 && $0.1 == 9 })
```

```swift
let anyNines = nums.↓reduce(false, { $0.0 || $0.1 == 9 })
```

```swift
let allValid = validators.↓reduce(true, { $0 && $1(input) })
```

```swift
let anyValid = validators.↓reduce(false, { $0 || $1(input) })
```

```swift
nums.reduce(into: true) { (r: inout Bool, s) in r = r && (s == 3) }
```