# Redundant Void Return

Returning Void in a function declaration is redundant

## Non Triggering Examples

```swift
func foo() {}
```

```swift
func foo() -> Int {}
```

```swift
func foo() -> Int -> Void {}
```

```swift
func foo() -> VoidResponse
```

```swift
let foo: (Int) -> Void
```

```swift
func foo() -> Int -> () {}
```

```swift
let foo: (Int) -> ()
```

```swift
func foo() -> ()?
```

```swift
func foo() -> ()!
```

```swift
func foo() -> Void?
```

```swift
func foo() -> Void!
```

```swift
struct A {
    subscript(key: String) {
        print(key)
    }
}
```

```swift
//
// include_closures: false
//

doSomething { arg -> Void in
    print(arg)
}

```

## Triggering Examples

```swift
func foo()↓ -> Void {}
```

```swift
protocol Foo {
  func foo()↓ -> Void
}
```

```swift
func foo()↓ -> () {}
```

```swift
func foo()↓ -> ( ) {}
```

```swift
protocol Foo {
  func foo()↓ -> ()
}
```

```swift
doSomething { arg↓ -> () in
    print(arg)
}
```

```swift
doSomething { arg↓ -> Void in
    print(arg)
}
```