# Self Binding

Re-bind `self` to a consistent identifier name.

## Non Triggering Examples

```swift
if let self = self { return }
```

```swift
guard let self = self else { return }
```

```swift
if let this = this { return }
```

```swift
guard let this = this else { return }
```

```swift
//
// bind_identifier: "this"
//

if let this = self { return }

```

```swift
//
// bind_identifier: "this"
//

guard let this = self else { return }

```

## Triggering Examples

```swift
if let ↓`self` = self { return }
```

```swift
guard let ↓`self` = self else { return }
```

```swift
if let ↓this = self { return }
```

```swift
guard let ↓this = self else { return }
```

```swift
//
// bind_identifier: "this"
//

if let ↓self = self { return }

```

```swift
//
// bind_identifier: "this"
//

guard let ↓self = self else { return }

```

```swift
//
// bind_identifier: "this"
//

if let ↓self { return }

```

```swift
//
// bind_identifier: "this"
//

guard let ↓self else { return }

```