# Strong IBOutlet

@IBOutlets shouldn't be declared as weak

## Non Triggering Examples

```swift
class ViewController: UIViewController {
    @IBOutlet var label: UILabel?
}
```

```swift
class ViewController: UIViewController {
    weak var label: UILabel?
}
```

## Triggering Examples

```swift
class ViewController: UIViewController {
    @IBOutlet ↓weak var label: UILabel?
}
```

```swift
class ViewController: UIViewController {
    @IBOutlet ↓unowned var label: UILabel!
}
```

```swift
class ViewController: UIViewController {
    @IBOutlet ↓weak var textField: UITextField?
}
```