# Superfluous Else

Else branches should be avoided when the previous if-block exits the current scope

## Non Triggering Examples

```swift
if i > 0 {
    // comment
} else if i < 12 {
    return 2
} else {
    return 3
}
```

```swift
if i > 0 {
    let a = 1
    if a > 1 {
        // comment
    } else {
        return 1
    }
    // comment
} else {
    return 3
}
```

```swift
if i > 0 {
    if a > 1 {
        return 1
    }
} else {
    return 3
}
```

```swift
for i in list {
    if i > 12 {
        // Do nothing
    } else {
        continue
    }
    if i > 14 {
        // Do nothing
    } else if i > 13 {
        break
    }
}
```

```swift
if #available(iOS 13, *) {
    return
} else {
    deprecatedFunction()
}
```

## Triggering Examples

```swift
if i > 0 {
    return 1
    // comment
} ↓else {
    return 2
}
```

```swift
if i > 0 {
    return 1
} ↓else if i < 12 {
    return 2
} ↓else if i > 18 {
    return 3
}
```

```swift
if i > 0 {
    if i < 12 {
        return 5
    } ↓else {
        if i > 11 {
            return 6
        } ↓else {
            return 7
        }
    }
} ↓else if i < 12 {
    return 2
} ↓else if i < 24 {
    return 8
} ↓else {
    return 3
}
```

```swift
for i in list {
    if i > 13 {
        return
    } ↓else if i > 12 {
        continue
    } ↓else if i > 11 {
        break
    } ↓else {
        throw error
    }
}
```