# Switch and Case Statement Alignment

Case statements should vertically align with their closing brace, or indented if configured otherwise.

## Non Triggering Examples

```swift
switch someBool {
case true: // case 1
    print('red')
case false:
    /*
    case 2
    */
    if case let .someEnum(val) = someFunc() {
        print('blue')
    }
}
enum SomeEnum {
    case innocent
}
```

```swift
if aBool {
    switch someBool {
    case true:
        print('red')
    case false:
        print('blue')
    }
}
```

```swift
switch someInt {
// comments ignored
case 0:
    // zero case
    print('Zero')
case 1:
    print('One')
default:
    print('Some other number')
}
```

```swift
func f() -> Int {
    return switch i {
    case 1: 1
    default: 2
    }
}
```

```swift
//
// ignore_one_liners: true
//

switch i { case .x: 1 default: 0 }

```

```swift
//
// ignore_one_liners: true
//

let a = switch i { case .x: 1 default: 0 }

```

## Triggering Examples

```swift
switch someBool {
    ↓case true:
        print("red")
    ↓case false:
        print("blue")
}
```

```swift
if aBool {
    switch someBool {
        ↓case true:
            print('red')
        ↓case false:
            print('blue')
    }
}
```

```swift
switch someInt {
    ↓case 0:
        print('Zero')
    ↓case 1:
        print('One')
    ↓default:
        print('Some other number')
}
```

```swift
let a = switch i {
    ↓case 1: 1
    ↓default: 2
}
```

```swift
switch someBool {
case true:
    print('red')
    ↓case false:
        print('blue')
}
```

```swift
if aBool {
    switch someBool {
        ↓case true:
        print('red')
    case false:
    print('blue')
    }
}
```

```swift
let a = switch i {
case 1: 1
    ↓default: 2
}
```

```swift
switch i { ↓case .x: 1 ↓default: 0 }
```

```swift
//
// ignore_one_liners: true
//

switch i {
↓case .x: 1 ↓default: 0 }

```

```swift
//
// ignore_one_liners: true
//

switch i { ↓case .x: 1 ↓default: 0
}

```

```swift
//
// ignore_one_liners: true
//

switch i
{ ↓case .x: 1 ↓default: 0 }

```

```swift
//
// ignore_one_liners: true
//

let a = switch i {
case .x: 1 ↓default: 0
}

```

```swift
//
// ignore_one_liners: true
//

let a = switch i {
↓case .x: 1 ↓default: 0 }

```