# Toggle Bool

Prefer `someBool.toggle()` over `someBool = !someBool`

## Non Triggering Examples

```swift
isHidden.toggle()
```

```swift
view.clipsToBounds.toggle()
```

```swift
func foo() { abc.toggle() }
```

```swift
view.clipsToBounds = !clipsToBounds
```

```swift
disconnected = !connected
```

```swift
result = !result.toggle()
```

## Triggering Examples

```swift
↓isHidden = !isHidden
```

```swift
↓view.clipsToBounds = !view.clipsToBounds
```

```swift
func foo() { ↓abc = !abc }
```