# Unneeded Parentheses in Closure Argument

Parentheses are not needed when declaring closure arguments

## Non Triggering Examples

```swift
let foo = { (bar: Int) in }
```

```swift
let foo = { bar, _  in }
```

```swift
let foo = { bar in }
```

```swift
let foo = { bar -> Bool in return true }
```

```swift
DispatchQueue.main.async { () -> Void in
    doSomething()
}
```

## Triggering Examples

```swift
call(arg: { ↓(bar) in })
```

```swift
call(arg: { ↓(bar, _) in })
```

```swift
let foo = { ↓(bar) -> Bool in return true }
```

```swift
foo.map { ($0, $0) }.forEach { ↓(x, y) in }
```

```swift
foo.bar { [weak self] ↓(x, y) in }
```

```swift
[].first { ↓(temp) in
    [].first { ↓(temp) in
        [].first { ↓(temp) in
            _ = temp
            return false
        }
        return false
    }
    return false
}
```

```swift
[].first { temp in
    [].first { ↓(temp) in
        [].first { ↓(temp) in
            _ = temp
            return false
        }
        return false
    }
    return false
}
```