# Unused Setter Value

Setter value is not used

## Non Triggering Examples

```swift
var aValue: String {
    get {
        return Persister.shared.aValue
    }
    set {
        Persister.shared.aValue = newValue
    }
}
```

```swift
var aValue: String {
    set {
        Persister.shared.aValue = newValue
    }
    get {
        return Persister.shared.aValue
    }
}
```

```swift
var aValue: String {
    get {
        return Persister.shared.aValue
    }
    set(value) {
        Persister.shared.aValue = value
    }
}
```

```swift
override var aValue: String {
 get {
     return Persister.shared.aValue
 }
 set { }
}
```

## Triggering Examples

```swift
var aValue: String {
    get {
        return Persister.shared.aValue
    }
    ↓set {
        Persister.shared.aValue = aValue
    }
}
```

```swift
var aValue: String {
    ↓set {
        Persister.shared.aValue = aValue
    }
    get {
        return Persister.shared.aValue
    }
}
```

```swift
var aValue: String {
    get {
        return Persister.shared.aValue
    }
    ↓set {
        Persister.shared.aValue = aValue
    }
}
```

```swift
var aValue: String {
    get {
        let newValue = Persister.shared.aValue
        return newValue
    }
    ↓set {
        Persister.shared.aValue = aValue
    }
}
```

```swift
var aValue: String {
    get {
        return Persister.shared.aValue
    }
    ↓set(value) {
        Persister.shared.aValue = aValue
    }
}
```

```swift
override var aValue: String {
    get {
        return Persister.shared.aValue
    }
    ↓set {
        Persister.shared.aValue = aValue
    }
}
```