# Vertical Parameter Alignment

Function parameters should be aligned vertically if they're in multiple lines in a declaration

## Non Triggering Examples

```swift
func validateFunction(_ file: SwiftLintFile, kind: SwiftDeclarationKind,
                      dictionary: SourceKittenDictionary) { }
```

```swift
func validateFunction(_ file: SwiftLintFile, kind: SwiftDeclarationKind,
                      dictionary: SourceKittenDictionary) -> [StyleViolation]
```

```swift
func foo(bar: Int)
```

```swift
func foo(bar: Int) -> String
```

```swift
func validateFunction(_ file: SwiftLintFile, kind: SwiftDeclarationKind,
                      dictionary: SourceKittenDictionary)
                      -> [StyleViolation]
```

```swift
func validateFunction(
   _ file: SwiftLintFile, kind: SwiftDeclarationKind,
   dictionary: SourceKittenDictionary) -> [StyleViolation]
```

```swift
func validateFunction(
   _ file: SwiftLintFile, kind: SwiftDeclarationKind,
   dictionary: SourceKittenDictionary
) -> [StyleViolation]
```

```swift
func regex(_ pattern: String,
           options: NSRegularExpression.Options = [.anchorsMatchLines,
                                                   .dotMatchesLineSeparators]) -> NSRegularExpression
```

```swift
func foo(a: Void,
         b: [String: String] =
         [:]) {
}
```

```swift
func foo(data: (size: CGSize,
                identifier: String)) {}
```

```swift
func foo(data: Data,
         @ViewBuilder content: @escaping (Data.Element.IdentifiedValue) -> Content) {}
```

```swift
class A {
    init(bar: Int)
}
```

```swift
class A {
    init(foo: Int,
         bar: String)
}
```

## Triggering Examples

```swift
func validateFunction(_ file: SwiftLintFile, kind: SwiftDeclarationKind,
                  ↓dictionary: SourceKittenDictionary) { }
```

```swift
func validateFunction(_ file: SwiftLintFile, kind: SwiftDeclarationKind,
                       ↓dictionary: SourceKittenDictionary) { }
```

```swift
func validateFunction(_ file: SwiftLintFile,
                  ↓kind: SwiftDeclarationKind,
                  ↓dictionary: SourceKittenDictionary) { }
```

```swift
func foo(data: Data,
            ↓@ViewBuilder content: @escaping (Data.Element.IdentifiedValue) -> Content) {}
```

```swift
class A {
    init(data: Data,
                ↓@ViewBuilder content: @escaping (Data.Element.IdentifiedValue) -> Content) {}
}
```