# Vertical Whitespace before Closing Braces

Don't include vertical whitespace (empty line) before closing braces

## Non Triggering Examples

```swift
[
1,
2,
3
]
```

```swift
do {
  print("x is 5")
}
```

```swift
do {
  print("x is 5")
}
```

```swift
do {
  print("x is 5")
}
```

```swift
foo(
    x: 5,
    y:6
)
```

```swift
func foo() {
  run(5) { x in
    print(x)
  }
}
```

```swift
//
// only_enforce_before_trivial_lines: true
//

print([
  1
])

```

```swift
//
// only_enforce_before_trivial_lines: true
//

print([foo {
  var sum = 0
  for i in 1...5 { sum += i }
  return sum

}, foo {
  var mul = 1
  for i in 1...5 { mul *= i }
  return mul
}])

```

```swift
[1, 2].map { $0 }.filter { true }
```

```swift
[1, 2].map { $0 }.filter { num in true }
```

```swift
/*
    class X {

        let x = 5

    }
*/
```

## Triggering Examples

```swift
[
1,
2,
3
↓
]
```

```swift
do {
  print("x is 5")
↓

}
```

```swift
do {
  print("x is 5")
↓
  
}
```

```swift
do {
  print("x is 5")
↓
}
```

```swift
foo(
    x: 5,
    y:6
↓
)
```

```swift
func foo() {
  run(5) { x in
    print(x)
  }
↓
}
```

```swift
//
// only_enforce_before_trivial_lines: true
//

print([
  1
↓
])

```

```swift
//
// only_enforce_before_trivial_lines: true
//

print([foo {
  var sum = 0
  for i in 1...5 { sum += i }
  return sum

}, foo {
  var mul = 1
  for i in 1...5 { mul *= i }
  return mul
↓
}])

```