# Void Return

Prefer `-> Void` over `-> ()`

## Non Triggering Examples

```swift
let abc: () -> Void = {}
```

```swift
let abc: () -> (VoidVoid) = {}
```

```swift
func foo(completion: () -> Void)
```

```swift
let foo: (ConfigurationTests) -> () throws -> Void
```

```swift
let foo: (ConfigurationTests) ->   () throws -> Void
```

```swift
let foo: (ConfigurationTests) ->() throws -> Void
```

```swift
let foo: (ConfigurationTests) -> () -> Void
```

```swift
let foo: () -> () async -> Void
```

```swift
let foo: () -> () async throws -> Void
```

```swift
let foo: () -> () async -> Void
```

```swift
func foo() -> () async throws -> Void {}
```

```swift
func foo() async throws -> () async -> Void { return {} }
```

```swift
func foo() -> () async -> Int { 1 }
```

## Triggering Examples

```swift
let abc: () -> ↓() = {}
```

```swift
let abc: () -> ↓(Void) = {}
```

```swift
let abc: () -> ↓(   Void ) = {}
```

```swift
func foo(completion: () -> ↓())
```

```swift
func foo(completion: () -> ↓(   ))
```

```swift
func foo(completion: () -> ↓(Void))
```

```swift
let foo: (ConfigurationTests) -> () throws -> ↓()
```

```swift
func foo() async -> ↓()
```

```swift
func foo() async throws -> ↓()
```