"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNativeEventNames = void 0;
let nativeEventNames = null;
function getNativeEventNames() {
    return (nativeEventNames !== null && nativeEventNames !== void 0 ? nativeEventNames : (nativeEventNames = new Set([
        // Source: https://developer.mozilla.org/en-US/docs/Web/Events
        'abort',
        'afterprint',
        'animationend',
        'animationiteration',
        'animationstart',
        'appinstalled',
        'audioprocess',
        'audioend',
        'audiostart',
        'beforeprint',
        'beforeunload',
        'beginEvent',
        'blocked',
        'blur',
        'boundary',
        'cached',
        'canplay',
        'canplaythrough',
        'change',
        'chargingchange',
        'chargingtimechange',
        'checking',
        'click',
        'close',
        'complete',
        'compositionend',
        'compositionstart',
        'compositionupdate',
        'contextmenu',
        'copy',
        'cut',
        'dblclick',
        'devicechange',
        'devicelight',
        'devicemotion',
        'deviceorientation',
        'deviceproximity',
        'dischargingtimechange',
        'DOMAttributeNameChanged',
        'DOMAttrModified',
        'DOMCharacterDataModified',
        'DOMContentLoaded',
        'DOMElementNameChanged',
        'focus',
        'focusin',
        'focusout',
        'DOMNodeInserted',
        'DOMNodeInsertedIntoDocument',
        'DOMNodeRemoved',
        'DOMNodeRemovedFromDocument',
        'DOMSubtreeModified',
        'downloading',
        'drag',
        'dragend',
        'dragenter',
        'dragleave',
        'dragover',
        'dragstart',
        'drop',
        'durationchange',
        'emptied',
        'end',
        'ended',
        'endEvent',
        'error',
        'fullscreenchange',
        'fullscreenerror',
        'gamepadconnected',
        'gamepaddisconnected',
        'gotpointercapture',
        'hashchange',
        'lostpointercapture',
        'input',
        'invalid',
        'keydown',
        'keypress',
        'keyup',
        'languagechange',
        'levelchange',
        'load',
        'loadeddata',
        'loadedmetadata',
        'loadend',
        'loadstart',
        'mark',
        'message',
        'messageerror',
        'mousedown',
        'mouseenter',
        'mouseleave',
        'mousemove',
        'mouseout',
        'mouseover',
        'mouseup',
        'nomatch',
        'notificationclick',
        'noupdate',
        'obsolete',
        'offline',
        'online',
        'open',
        'orientationchange',
        'pagehide',
        'pageshow',
        'paste',
        'pause',
        'pointercancel',
        'pointerdown',
        'pointerenter',
        'pointerleave',
        'pointerlockchange',
        'pointerlockerror',
        'pointermove',
        'pointerout',
        'pointerover',
        'pointerup',
        'play',
        'playing',
        'popstate',
        'progress',
        'push',
        'pushsubscriptionchange',
        'ratechange',
        'readystatechange',
        'repeatEvent',
        'reset',
        'resize',
        'resourcetimingbufferfull',
        'result',
        'resume',
        'scroll',
        'seeked',
        'seeking',
        'select',
        'selectstart',
        'selectionchange',
        'show',
        'soundend',
        'soundstart',
        'speechend',
        'speechstart',
        'stalled',
        'start',
        'storage',
        'submit',
        'success',
        'suspend',
        'SVGAbort',
        'SVGError',
        'SVGLoad',
        'SVGResize',
        'SVGScroll',
        'SVGUnload',
        'SVGZoom',
        'timeout',
        'timeupdate',
        'touchcancel',
        'touchend',
        'touchmove',
        'touchstart',
        'transitionend',
        'unload',
        'updateready',
        'upgradeneeded',
        'userproximity',
        'voiceschanged',
        'versionchange',
        'visibilitychange',
        'volumechange',
        'waiting',
        'wheel',
    ])));
}
exports.getNativeEventNames = getNativeEventNames;
