#!/bin/bash

# Usage teamscale.sh [-c <path-to-teamscale-config.properties>]

# Ensures, that files created by Teamscale can by accessed by the user group.
# This is necessary for Kubernetes environments where actual user might change with every container restart
umask 002

if [ -z "$TEAMSCALE_HOME" ]
then
    export TEAMSCALE_HOME=`dirname "$0"`
fi

if [ -z "$TEAMSCALE_VM_ARGS" ]
then
    export TEAMSCALE_VM_ARGS=
fi

JAVA_VERSION=$(JAVA_OPTS="-fullversion" "$TEAMSCALE_HOME/bin/Teamscale" 2>&1)
JAVA_MAJOR_VERSION=$(echo "$JAVA_VERSION" | cut -d\" -f 2 | cut -d. -f 1 | cut -d+ -f 1)
if [ "$JAVA_MAJOR_VERSION" -lt "25" ]; then
    echo "Teamscale requires a minimum java version of 25, but you tried to execute it with '$JAVA_VERSION'."
    exit 1
fi

if [ -n "$TEAMSCALE_CONFIG" ]
then
    TEAMSCALE_CONFIG__JVM_PROPERTIES="$TEAMSCALE_CONFIG/jvm.properties"
elif [ -r "$PWD/config/jvm.properties" ]
then
    TEAMSCALE_CONFIG__JVM_PROPERTIES="$PWD/config/jvm.properties"
else
    TEAMSCALE_CONFIG__JVM_PROPERTIES="$TEAMSCALE_HOME/config/jvm.properties"
fi

if [ -r "$TEAMSCALE_CONFIG__JVM_PROPERTIES" ]
then
    while read -r line || [ -n "$line" ];
    do
        # skip empty and comment lines
        if  echo "$line" | grep -v -q -x -e '\s*#.*\|\s*'
        then
            declare "`echo -n $line | tr -d "\r\n"`"
        fi
    done < "$TEAMSCALE_CONFIG__JVM_PROPERTIES"
fi

if [ -z "$TEAMSCALE_MEMORY" ]
then
    export TEAMSCALE_MEMORY=$JVM_MEMORY
fi

if [ -z "$TEAMSCALE_MEMORY" ]
then
    export TEAMSCALE_MEMORY=4096m
fi

if [ -n "$TEAMSCALE_TEMP" ]
then
    if [ ! -d "$TEAMSCALE_TEMP" ]
    then
         mkdir -p "$TEAMSCALE_TEMP"
    fi
    TEAMSCALE_TEMP="-Djava.io.tmpdir='$TEAMSCALE_TEMP'"
fi

export TEAMSCALE_OPTS="-Xmx$TEAMSCALE_MEMORY $TEAMSCALE_TEMP $TEAMSCALE_OPTS $TEAMSCALE_VM_ARGS $JVM_EXTRA_ARGS"

# Use exec so that any signals are redirected to teamscale
exec "$TEAMSCALE_HOME/bin/Teamscale" "$@"
