import{_ as i,c as a,ak as n,o as t}from"./chunks/framework.CM689eR4.js";const E=JSON.parse('{"title":"Requesting Findings Churn via API","description":"","frontmatter":{"title":"Requesting Findings Churn via API"},"headers":[],"relativePath":"howto/requesting-findings-churn/index.md","filePath":"howto/requesting-findings-churn/index.md"}'),e={name:"howto/requesting-findings-churn/index.md"};function h(l,s,p,k,o,d){return t(),a("div",null,[...s[0]||(s[0]=[n(`<h1 id="how-to-request-the-findings-churn-for-a-commit-via-the-rest-api" tabindex="-1">How to Request the Findings Churn for a Commit via the REST API <a class="header-anchor" href="#how-to-request-the-findings-churn-for-a-commit-via-the-rest-api" aria-label="Permalink to &quot;How to Request the Findings Churn for a Commit via the REST API&quot;">​</a></h1><p>Teamscale calculates the <a href="./../../glossary/#findings-churn">finding churn</a> for each commit of the repository. This article shows you how you can query this information using <a href="./../../reference/rest-api/">Teamscale&#39;s REST API</a>, so that you can, for example, include it in your build logs. It makes the following assumptions:</p><ul><li>You already have a running Teamscale instance.</li><li>You know the <em>revision</em> of your <em>commit</em>, e.g., the Git commit hash or SVN revision number.</li><li>You want to query the API using the command line (or generate a client in your programming language of choice from the OpenAPI specification).</li></ul><div class="tip custom-block"><p class="custom-block-title">REST API Authentication</p><p>Details on authentication is explained <a href="./../../reference/rest-api/#authentication">in the REST API article</a>.</p></div><h2 id="step-1-resolve-revision-to-branch-timestamp" tabindex="-1">Step 1: Resolve Revision to Branch &amp; Timestamp <a class="header-anchor" href="#step-1-resolve-revision-to-branch-timestamp" aria-label="Permalink to &quot;Step 1: Resolve Revision to Branch &amp; Timestamp&quot;">​</a></h2><p>Internally, Teamscale stores commit-related data as a pair of branch and timestamp (in milliseconds since the Unix epoch), e.g., <code>master:1234567890</code>. To query this tuple for a given revision (variable <code>COMMIT_REVISION</code>), you can perform a <code>GET</code> query to the <code>revision</code> endpoint:</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">RESPONSE</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;$(</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">curl</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> \\</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  --user</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> \${</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">USER_NAME</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">}:\${</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">ACCESS_KEY</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">} </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  --header</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &#39;Accept: application/json&#39; </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\</span></span>
<span class="line"><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">  &quot;\${</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">TEAMSCALE_URL</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">}/api/v2026.1/projects/\${</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">PROJECT_ID</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">}/revision/\${</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">COMMIT_REVISION</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">}/commits&quot;)&quot;</span></span></code></pre></div><p>The value of the <code>RESPONSE</code> variable will look like this:</p><div class="language-json vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">json</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">[</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;branchName&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;master&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;timestamp&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">1581410860000</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">]</span></span></code></pre></div><p>You need to store the values of <code>branchName</code> and <code>timestamp</code> for the follow-up server call.</p><div class="tip custom-block"><p class="custom-block-title">Accessing JSON on Command Line</p><p>To access JSON properties on the command line, you can, e.g., use <a href="https://stedolan.github.io/jq/" target="_blank" rel="noreferrer"><code>jq</code></a>.</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">BRANCH</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;$(</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">echo</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;\${</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">RESPONSE</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">}&quot; </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">|</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> jq</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --raw-output</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &#39;.[0].branchName&#39;)&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">TIMESTAMP</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;$(</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">echo</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;\${</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">RESPONSE</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">}&quot; </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">|</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> jq</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &#39;.[0].timestamp&#39;)&quot;</span></span></code></pre></div></div><h2 id="step-2-load-findings-for-commit" tabindex="-1">Step 2: Load Findings for Commit <a class="header-anchor" href="#step-2-load-findings-for-commit" aria-label="Permalink to &quot;Step 2: Load Findings for Commit&quot;">​</a></h2><p>Assuming you stored <code>BRANCH</code> and <code>TIMESTAMP</code> from the response of the first step, you can now query the findings churn for the commit at hand:</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">curl</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> \\</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  --user</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> \${USER_NAME}</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">:</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">\${ACCESS_KEY} </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  --header</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &#39;Accept: application/json&#39;</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> \\</span></span>
<span class="line"><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">  &quot;\${</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">TEAMSCALE_URL</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">}/api/v2026.1/projects/\${</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">PROJECT_ID</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">}/finding-churn/list/?t=\${</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">BRANCH</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">}%3A\${</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">TIMESTAMP</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">}&quot;</span></span></code></pre></div><p>A sample (shortened) response with one removed finding looks like this:</p><div class="language-json vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">json</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">{</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;addedFindings&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [],</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;findingsAddedInBranch&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [],</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;findingsInChangedCode&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [],</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;removedFindings&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;groupName&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;Bad practice&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;categoryName&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;Code Anomalies&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;message&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;Method \`console.log\` should not be called&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;assessment&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;RED&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">      // ...</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    }</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">    // ...</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  ]</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">}</span></span></code></pre></div><p>As you can see, the response contains four lists of findings:</p><ul><li><code>addedFindings</code>: the findings that were added with this commit</li><li><code>findingsAddedInBranch</code>: in case of a <em>merge commit</em>, the findings that are now present on the target branch but originated from the source branch</li><li><code>findingsInChangedCode</code>: the findings that were already present in touched code, but were not resolved with this commit</li><li><code>removedFindings</code>: the findings that were removed with this commit</li></ul><h2 id="step-3-example-use-case-counting-the-findings" tabindex="-1">Step 3: Example Use Case: Counting the Findings <a class="header-anchor" href="#step-3-example-use-case-counting-the-findings" aria-label="Permalink to &quot;Step 3: Example Use Case: Counting the Findings&quot;">​</a></h2><p>In case you want to count the findings, you can use the aforementioned <a href="https://stedolan.github.io/jq/" target="_blank" rel="noreferrer">jq</a> tool again. Assuming you stored the response from Step 2 in a file using <code>--output findings-churn.json</code>, you can determine the number of findings in various lists like this:</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">ADDED_FINDINGS</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">$(</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">jq</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &#39;.addedFindings | length&#39;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> findings-churn.json</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">)</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">REMOVED_FINDINGS</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">$(</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">jq</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &#39;.removedFindings | length&#39;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> findings-churn.json</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">)</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">FINDINGS_IN_CHANGED_CODE</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">$(</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">jq</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &#39;.findingsInChangedCode | length&#39;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> findings-churn.json</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">)</span></span></code></pre></div><p>Combining all the information gathered for the commit at hand, you can then build a link to the <em>Commit Detail</em> view in Teamscale that spells out the finding churn in its link text:</p><div class="language-html vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">html</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">a</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> href</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;\${TEAMSCALE_URL}/activity/details/\${PROJECT_ID}?t=\${BRANCH}%3A\${TIMESTAMP}&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  Commit \${COMMIT_REVISION} added \${ADDED_FINDINGS}, ignored \${FINDINGS_IN_CHANGED_CODE}, and removed \${REMOVED_FINDINGS} findings</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">a</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span></code></pre></div>`,23)])])}const g=i(e,[["render",h]]);export{E as __pageData,g as default};
