import{_ as i}from"./chunks/tga-test-gaps.CGjhZutw.js";import{_ as n,c as r,ak as a,b as e,x as s,O as h,L as l,o as d}from"./chunks/framework.CM689eR4.js";const p="/assets/tga-hide-unchanged-methods.C1JgNBWK.png",c="/assets/treemap-popup.C2XVhznY.png",m="/assets/method-history.D9qV1O4_.png",g="/assets/tga-method-states.CKgy4j3T.png",u="/assets/tga-coverage-sources.DOxlMiut.png",z=JSON.parse('{"title":"Working with Test Gap Treemaps","description":"","frontmatter":{"title":"Working with Test Gap Treemaps"},"headers":[],"relativePath":"howto/working-with-test-gap-treemaps/index.md","filePath":"howto/working-with-test-gap-treemaps/index.md"}'),w={name:"howto/working-with-test-gap-treemaps/index.md"},f={class:"tip custom-block"},y={class:"custom-block-title"};function T(b,t,v,G,k,_){const o=l("Badge");return d(),r("div",null,[t[2]||(t[2]=a('<h1 id="working-with-test-gap-treemaps" tabindex="-1">Working with Test Gap Treemaps <a class="header-anchor" href="#working-with-test-gap-treemaps" aria-label="Permalink to &quot;Working with Test Gap Treemaps&quot;">​</a></h1><p>As a tester or release manager, you often want to know which changes to your software system were not sufficiently tested. Teamscale&#39;s Test Gap analysis (TGA) automatically identifies such changes for you. The results of this analysis, i.e., the <a href="./../../glossary/#test-gap">Test Gaps</a>, appear as Test Gap treemaps in <a href="./../../reference/ui/testgaps/">the <em>Test Gaps</em> perspective</a> and on <a href="./../../howto/creating-a-tga-dashboard/">TGA dashboards</a>.</p><p>For each Test Gap, you should decide whether or not the corresponding source code should be tested, e.g., by focusing on those changes with the highest risk. To make such decisions, you typically need to know which functionality a specific Test Gap, i.e., the respective method, belongs to and which changes were made to it. This guide explains how to achieve this using Test Gap treemaps:</p><nav class="table-of-contents"><ul><li><a href="#reading-test-gap-treemaps">Reading Test Gap Treemaps</a></li><li><a href="#working-with-large-treemaps">Working with Large Treemaps</a></li><li><a href="#analyzing-individual-test-gaps">Analyzing Individual Test Gaps</a></li><li><a href="#adjusting-baseline-and-end-date">Adjusting Baseline and End Date</a></li><li><a href="#separating-test-stages">Separating Test Stages</a></li></ul></nav><p>You may also watch our <a href="./#webinar">webinar on Test Gap analysis</a> to see parts of this guide in action.</p><h2 id="reading-test-gap-treemaps" tabindex="-1">Reading Test Gap Treemaps <a class="header-anchor" href="#reading-test-gap-treemaps" aria-label="Permalink to &quot;Reading Test Gap Treemaps&quot;">​</a></h2><p>The picture below shows an example of a Test Gap treemap. The structure of such a treemap visualizes the source code of your software system. Each rectangle corresponds to one method in the source code. The bigger the rectangle, the longer the method (measured in <a href="https://en.wikipedia.org/wiki/Source_lines_of_code" target="_blank" rel="noreferrer">source lines of code</a>).</p><p><img src="'+i+'" alt="Test Gaps on a Treemap" width="1882" height="1113" data-zoom="true"></p><p>The colors on the treemap indicate which of the following TGA states the respective methods are in:</p><ul><li><span class="label gray" style="width:40pt;margin-bottom:3pt;">Gray</span> methods remain unchanged since the <a href="./#adjusting-baseline-and-end-date">TGA baseline</a>.</li><li><span class="label green" style="width:40pt;margin-bottom:3pt;">Green</span> methods were changed since the baseline and later <em>executed in a test</em>.</li><li><span class="label yellow" style="width:40pt;margin-bottom:3pt;">Yellow</span> methods were changed since the baseline and <em>not executed in any test since</em>.</li><li><span class="label red" style="width:40pt;margin-bottom:3pt;">Red</span> methods were newly introduced since the baseline and <em>not executed in any test</em>.</li></ul><p>The red and yellow boxes of the treemap are your Test Gaps, i.e., they contain the changes to your software system that have not been executed in any test. When you move the mouse over the treemap, a tooltip shows details on the respective Test Gap. This allows you to do a first high-level analysis.</p><div class="warning custom-block"><p class="custom-block-title">Reduce Risk vs. All Green</p><p>Test Gap analysis enables conscious decisions about where to direct your limited testing resources, in order to minimize the risk that comes with changes to your software system. The goal is to prevent changes from slipping through testing without you knowing, not to try to close all Test Gaps. An all-green Test Gap treemap does not give you any guarantees, since it cannot prove the absence of bugs.</p></div><div class="tip custom-block"><p class="custom-block-title">Export Test Gap Data</p><p>You may download a CSV file listing all the methods and their corresponding TGA state, by clicking on the <i class="download icon"></i> icon in the upper-left of the treemap.</p></div><div class="tip custom-block"><p class="custom-block-title">Excluding Test Code</p><p>In some cases test gaps for changed test code is not relevant (e.g. if no coverage for test code is available). To ignore changed test code in Test Gap Treemaps, you can use the &quot;Test-code path pattern&quot; option in the Advanced Settings for the respective repository connector.</p></div><h2 id="working-with-large-treemaps" tabindex="-1">Working with Large Treemaps <a class="header-anchor" href="#working-with-large-treemaps" aria-label="Permalink to &quot;Working with Large Treemaps&quot;">​</a></h2><p>In case of very large systems, rectangles in the Test Gap treemap may become very small and hard to distinguish. Teamscale provides two features to help you work with such large treemaps.</p><p>For one, it often helps to enable the <em>Hide unchanged methods</em> option in the treemap&#39;s properties, which hides all the gray rectangles on the treemap, as shown in the following figure. This helps you focus on the changes, especially if they are few compared to the overall size of your system. On the down side, all changes are now next to each other, which means to cannot immediately see which of them are close to each other in the codebase and which are far apart.</p><p><img src="'+p+'" alt="Test Gap Treemap with Focus on Changes" width="2324" height="1156" data-zoom="true"></p><p>Alternatively, you may zoom into a part of the treemap, to focus on individual components of your entire software system. When you click on a Test Gap in a treemap, the tooltip changes into a persistent state that allows you to select an element of the path. If you do this, the treemap switches to show only the code inside the respective subpath of the system. To return to the treemap of the entire system, click anywhere on the treemap and select <em>All Methods</em> from the tooltip.</p><p><img src="'+c+'" alt="Persistent Tooltip on a Test Gap Treemap" width="1236" height="178" data-zoom="true"></p><h2 id="analyzing-individual-test-gaps" tabindex="-1">Analyzing Individual Test Gaps <a class="header-anchor" href="#analyzing-individual-test-gaps" aria-label="Permalink to &quot;Analyzing Individual Test Gaps&quot;">​</a></h2><p>To analyze a particular Test Gap in detail, click on it in a Test Gap treemap and select <em>Open Method</em> from the tooltip, to see a history of the changes and test activity on the respective method, newest activity at the top.</p><p><img src="'+m+'" alt="Change and Test History on the setDistance Method" width="1000" height="663" data-zoom="true"></p><p>In particular, this history shows you when the latest test executed the method (if any) and which changes happened after that test. Often, this information is sufficient for a rough estimation of the Test Gap&#39;s severity.</p><p>To view the concrete untested change in the code, change to the <em>Compare method</em> tab and ensure that <em>Compare to latest tested version (if existing)</em> is enabled. The compare view below will then show you exactly the untested change or simply the entire method content, if it was never tested.</p>',25)),e("div",f,[e("p",y,[t[0]||(t[0]=s("Collaborate with Developers and Testers ",-1)),h(o,{text:"Best Practice"})]),t[1]||(t[1]=e("p",null,"You should bring developers and testers together for analyzing Test Gaps. With inside knowledge about both the development activities and the testing requirements and processes at the table, assessments of and decisions about Test Gaps become easy.",-1))]),t[3]||(t[3]=a('<h2 id="adjusting-baseline-and-end-date" tabindex="-1">Adjusting Baseline and End Date <a class="header-anchor" href="#adjusting-baseline-and-end-date" aria-label="Permalink to &quot;Adjusting Baseline and End Date&quot;">​</a></h2><p>Teamscale always analyzes Test Gaps between a <a href="./../../glossary/#baseline">baseline</a>, i.e., the starting point of the analysis, and an end date. While the baseline is typically a specific time in the past, such as the last release, the end date is often simply <em>now</em>. The following picture shows the impact of different baselines and end dates on the TGA state of a particular method.</p><p><img src="'+g+'" alt="Test Gap States of an individual method" width="1450" height="994" data-zoom="true"></p><p>The first bar shows the method&#39;s entire history. The method is first added, then tested, then changed, later changed again, then tested again, and so on. If we choose a baseline before the method was added, TGA considers the method as added since the baseline. Furthermore, if we choose an end date after the last test, TGA considers the method as tested since the latest modification. As a result, the method appears green in Test Gap treemaps.</p><p>The second bar shows the effect of moving the baseline forward. TGA now considers the method as modified since the baseline, because it existed at the baseline and changes were made to it afterwards. Since the latest version of the method was still tested, the method still to appear green in Test Gap treemaps.</p><p>The third bar now shows the effect of additionally moving the end date backwards to somewhere between a change and the subsequent test. TGA still considers the method as modified since the baseline, but since no test happened after the latest change, the method appears yellow in Test Gap treemaps. If we would now move the baseline back to before the method was added, the method would instead appear red.</p><p>Finally, the fourth bar shows the effect of moving the baseline forward until after the latest change. TGA now considers the method as unchanged since the baseline and it appears gray in Test Gap treemaps, regardless of later tests and the end date.</p><h2 id="separating-test-stages" tabindex="-1">Separating Test Stages <a class="header-anchor" href="#separating-test-stages" aria-label="Permalink to &quot;Separating Test Stages&quot;">​</a></h2><p>When analyzing Test Gaps, you may want to distinguish which changes were executed at which test stage, e.g., by unit tests vs. <a href="./../../howto/setting-up-profiler-tga/manual-tests/">manual end-to-end tests</a>. Teamscale allows you to do this, if you upload the code coverage from the individual test stages to separate <a href="./../../glossary/#partition">Partitions</a>. During Test Gap analysis, you may then select any (combination of) these partitions as the <em>Coverage Sources</em> to consider in the treemap&#39;s properties:</p><p><img src="'+u+'" alt="Coverage Source for Test Gap Analysis" width="632" height="410" data-zoom="true"></p><hr><h4 id="webinar" tabindex="-1">Webinar: <a class="header-anchor" href="#webinar" aria-label="Permalink to &quot;Webinar:&quot;">​</a></h4>',12)),t[4]||(t[4]=e("div",{class:"tip custom-block"},[e("p",{class:"custom-block-title"},[e("i",{class:"video icon"}),s(" Webinar on Test Gap Analysis")]),e("br"),e("iframe",{width:"560",height:"315",src:"https://www.youtube.com/embed/Dp1WmWdkcLM?rel=0&enablejsapi=1",frameborder:"0",allow:"accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture",allowfullscreen:"true"}),e("ul",null,[e("li",null,"0:00: Motivation and Basics"),e("li",null,"33:30: Practical Examples and Technical Details"),e("li",null,"52:44: Live Demo"),e("li",null,"1:10:30: Cost-Benefit Analysis")])],-1))])}const S=n(w,[["render",T]]);export{z as __pageData,S as default};
