import{_ as t,c as i,ak as a,o as s}from"./chunks/framework.CM689eR4.js";const n="/assets/verification-matrix.CiCTmLI9.png",r="/assets/process.gv6c2gtD.png",o="/assets/review-checklist.1Dq3jdge.png",c="/assets/gitlab.BkWiWIO_.png",l="/assets/dashboard.C4nTEvm_.png",u="/assets/requirement-link.BNxe-v5i.png",w=JSON.parse('{"title":"Agile Requirements Tracing","description":"","frontmatter":{"title":"Agile Requirements Tracing"},"headers":[],"relativePath":"introduction/agile-requirements-tracing/index.md","filePath":"introduction/agile-requirements-tracing/index.md"}'),h={name:"introduction/agile-requirements-tracing/index.md"};function m(d,e,f,p,g,q){return s(),i("div",null,[...e[0]||(e[0]=[a('<h1 id="agile-requirements-tracing-with-teamscale" tabindex="-1">Agile Requirements Tracing with Teamscale <a class="header-anchor" href="#agile-requirements-tracing-with-teamscale" aria-label="Permalink to &quot;Agile Requirements Tracing with Teamscale&quot;">​</a></h1><p>Teamscale provides a broad range of functionality to facilitate requirements tracing for agile software development teams. It reads requirements from several requirements management tools and interprets links to test code and test results. The gathered information about requirements and their connection to other artifacts can be visualized in a verification matrix or in a variety of dashboard widgets. Moreover, Teamscale provides a novel, lightweight way to keep the software specification and implementation up-to-date and in sync, by listing the relevant requirements for a code change directly in merge requests. As a result, teams get the benefits of requirements tracing without having to manually curate spreadsheets and avoid the bureaucracy of waterfall-like development processes.</p><h2 id="requirements-tracing-build-confidence-in-your-system" tabindex="-1">Requirements Tracing: Build Confidence in Your System <a class="header-anchor" href="#requirements-tracing-build-confidence-in-your-system" aria-label="Permalink to &quot;Requirements Tracing: Build Confidence in Your System&quot;">​</a></h2><p>If you need confidence that your software system is correct with respect to its requirements, it is necessary that you rigorously capture all these requirements and trace them to the tests that verify them. Unsurprisingly, <a href="./../../glossary/#requirements-tracing">requirements tracing</a> is heavily used in the engineering of safety-critical systems and described in standards from various domains, including</p><ul><li>ISO 26262 for automotive software,</li><li>DO-178C/ED-12C for avionic systems, or</li><li>ISO 13485/IEC 62304 which is used for medical devices.</li></ul><p>But requirements tracing is a useful ally in other contexts as well, especially when incorrect behavior of a software system may cause damage or financial loss.</p><p>One of the main goals of requirements tracing is to be able to demonstrate that the requirements have been tested thoroughly enough. To this end, a <strong>verification</strong> matrix is created, which forms the basis to investigate the relationship between requirements and tests:</p><p><img src="'+n+'" alt="Verification Matrix Showing Tests Which are Linked to Requirements and the Result of Their Last Execution" width="1809" height="504" data-zoom="true"></p><p>The verification matrix allows you to answer the following important questions in a facts-driven way:</p><ul><li>Are there any requirements without associated tests?</li><li>Do the tests for a given requirement provide sufficient risk mitigation?</li><li>Have all relevant tests been executed successfully on the release candidate?</li><li>Are there any tests that claim to verify a large number of requirements?</li></ul><p>These questions aim to identify weaknesses in the verification activities for your software system.</p><h2 id="the-problem-how-to-keep-everything-in-sync" tabindex="-1">The Problem: How to Keep Everything in Sync? <a class="header-anchor" href="#the-problem-how-to-keep-everything-in-sync" aria-label="Permalink to &quot;The Problem: How to Keep Everything in Sync?&quot;">​</a></h2><p>To be able to create a verification matrix, you need to combine the requirements of your system with the available tests and the connection between them. This already sounds non-trivial. To make things worse, code and tests are continuously modified during the evolution of the system. A software development project always entails a learning experience. Hence, the requirements are subject to change when the project progresses. Keeping requirements, tests, and the relations between them in sync is a major challenge in software engineering.</p><p>Standards that promote requirements tracing, like the ones mentioned above, often use waterfall-like processes as their underlying mental model. But although it is desirable that the documentation looks as if the product was developed in a fully rational top-down manner, in practice this is not happening. The following diagram depicts how one software engineering artifact influences the other:</p><p><img src="'+r+'" alt="In Practice the Flow of Activities in Projects is Usually Not Only Top-Down" width="2564" height="1316" data-zoom="true"></p><p>Especially in challenging, innovative projects, going back-and-forth between working on requirements, architecture and design, code, and tests is inevitable. Agile software development methods even explicitly embrace change and learnings in development projects.</p><p>Traditional methods for creating verification matrices often require a lot of manual effort and time. This is in stark contrast to modern, change-based quality assurance methods such as merge-request based reviews and quality gates.</p><p>Teamscale helps to combine modern, agile software engineering with safety- and correctness-centric development - without the usual bureaucracy.</p><h2 id="ensure-consistency-between-requirements-and-code-in-your-merge-requests" tabindex="-1">Ensure Consistency Between Requirements and Code in Your Merge Requests <a class="header-anchor" href="#ensure-consistency-between-requirements-and-code-in-your-merge-requests" aria-label="Permalink to &quot;Ensure Consistency Between Requirements and Code in Your Merge Requests&quot;">​</a></h2><p>Modern software quality assurance happens in merge requests. In code collaboration platforms like GitHub, Bitbucket, GitLab, Gerrit, etc., the merge request (or sometimes called &quot;pull request&quot;) is usually where changes are peer-reviewed. This helps to avoid breaking anything or blocking other developers and keeps the main branch in a releasable quality. Thus, it is a natural fit for making sure that requirements and code are kept in sync. For instance, if a test is changed, the reviewer should make sure it still verifies the requirement. However, as requirements specifications are often lengthy, figuring out which parts of a specification are affected by a change is usually hard.</p><p>Teamscale makes this task much easier for the reviewer. It automatically creates a review checklist that contains all items of your requirements specification that are potentially impacted by the code changes in a merge request:</p><p><img src="'+o+'" alt="Automatically Generated Review Checklist for a Merge Request in Teamscale" width="1843" height="1145" data-zoom="true"></p><p>As prerequisite for this review checklist, you need to connect Teamscale to your requirements management system and point it to tracing information. Tracing can be expressed in form of links in the code. While Teamscale analyzes the commits on a branch, it also captures all <a href="./../../glossary/#specification-item">specification items</a> that are potentially impacted by the code changes. Teamscale then annotates the number of impacted specification items in the corresponding merge request, including a link to the detailed review checklist. This makes it easy for the reviewer to ensure everything is in sync before merging the change.</p><p><img src="'+c+'" alt="Annotation of Impacted Spec Items in GitLab" width="1939" height="887" data-zoom="true"></p><h2 id="how-to-get-your-requirements-into-teamscale" tabindex="-1">How to Get Your Requirements into Teamscale? <a class="header-anchor" href="#how-to-get-your-requirements-into-teamscale" aria-label="Permalink to &quot;How to Get Your Requirements into Teamscale?&quot;">​</a></h2><p>Requirements are usually stored in a requirements management tool that allows to capture requirements – and often other parts of a specification as well. Teamscale can be directly connected to <a href="./../../reference/supported-technologies/requirements-management-tools/">several requirements management tools</a> using dedicated connectors. As a fallback, specifications can be read from CSV files, e.g., stored in a version control system.</p><p>Since specifications usually do not only contain requirements but also related artifacts such as &quot;Use Cases&quot;, &quot;Goals&quot;, &quot;Components&quot; or items, all these entities are called specification items in Teamscale. Specification items can have user-defined types, such as &quot;Requirement&quot;, &quot;Use Case,&quot; or similar that reflect the different parts of the specification documents used. Teamscale stores the specification items in a fully historized manner and provides a query language for filtering them. Specification item queries also the basis for defining metrics such as &quot;number of requirements in draft state&quot; or &quot;requirements that are in review for longer than 14 days&quot;. These metrics can be used in dashboards to provide insights about quality aspects of the specification next to quality data from code and test analyses:</p><p><img src="'+l+'" alt="Dashboard Showing Information about Requirements and Code Quality for a Software System" width="3370" height="2257" data-zoom="true"></p><h2 id="how-to-enable-tracing-between-tests-and-requirements" tabindex="-1">How to Enable Tracing Between Tests and Requirements? <a class="header-anchor" href="#how-to-enable-tracing-between-tests-and-requirements" aria-label="Permalink to &quot;How to Enable Tracing Between Tests and Requirements?&quot;">​</a></h2><p>Teamscale is able to detect automated test cases written using <a href="./../../reference/supported-technologies/test-frameworks/">common test frameworks</a> such as GTest (C++) or pytest (Python). If you annotate tests with the identifier of a specification item, Teamscale recognizes that this test contributes to the verification of the mentioned requirement and will present it, e.g., in the verification matrix.</p><p><img src="'+u+'" alt="Teamscale Automatically Detects Tests and Extracts References to Requirements" width="1884" height="1240" data-zoom="true"></p><p>When using test frameworks that are not (yet) supported by Teamscale or if you have written a custom test framework, you can simply mark methods in your code that represent an entry point to a test using a dedicated, custom comment. This tells Teamscale that these methods are tests that contribute to the verification of requirements.</p><p>Whenever a test is modified, Teamscale lists the corresponding impacted specification items in the merge request, so that all relevant information is accessible immediately to the reviewer without the need to dig through lengthy documents.</p><p>If provided to Teamscale, test results are mapped to the detected test declarations as well. This allows you to make sure that the tests have really been executed successfully. You can even distinguish different test sources, for instance when your tests are executed on different platforms, and of course different branches in your repository.</p><h2 id="what-s-the-difference-between-requirements-and-issues" tabindex="-1">What’s the Difference Between Requirements and Issues? <a class="header-anchor" href="#what-s-the-difference-between-requirements-and-issues" aria-label="Permalink to &quot;What’s the Difference Between Requirements and Issues?&quot;">​</a></h2><p>This is a question that often arises when teams start to introduce requirements-driven processes. What makes the situation extra confusing is that many times the same tools are used for requirements management and issue tracking (e.g., Jira). In Teamscale, we distinguish between two use cases:</p><ul><li><strong>Requirements specifications</strong> are typically regarded to be part of the product and thus need to be updated while the software is evolving.</li><li><strong>Issues</strong> (or tickets, work items, or similar) are a means of project management and help with the planning and organization of tasks that need to be done.</li></ul><p>Although an issue can be a task like &quot;implement requirement X&quot;, there still does not have to be a 1:1 mapping. Issues might refer to multiple requirements, the implementation of a component, or a feature.</p><p>In many cases, issues are change requests: they describe a modification or extension of existing functionality. If the functionality that should be modified has been specified with requirements before, these requirements have to be modified accordingly. Furthermore, issues can be completely unrelated to requirements, e.g., modifications of the CI pipeline, documentation tasks, etc. Thus, issues often have final states (e.g., &quot;Done&quot; or &quot;Discarded) and are usually not intended to be further maintained in this state. In contrast, requirements usually have a different lifecycle: they should persist and be updated as long as the software is intended to provide the specified capabilities.</p><p>Consequently, requirements and issues are separate concepts in Teamscale. We treat them differently although their data sources might overlap. For instance, Jira might be used as issue tracker and as requirements management tool. Teamscale provides separate Jira connectors for both use cases.</p>',40)])])}const b=t(h,[["render",m]]);export{w as __pageData,b as default};
