import{_ as t,c as r,ak as a,o}from"./chunks/framework.CM689eR4.js";const p=JSON.parse('{"title":"Permission Management","description":"","frontmatter":{},"headers":[],"relativePath":"reference/permission-management/index.md","filePath":"reference/permission-management/index.md"}'),s={name:"reference/permission-management/index.md"};function i(l,e,n,d,c,m){return o(),r("div",null,[...e[0]||(e[0]=[a('<h1 id="permission-management" tabindex="-1">Permission Management <a class="header-anchor" href="#permission-management" aria-label="Permalink to &quot;Permission Management&quot;">​</a></h1><p>In this article, the permission &amp; access right management in Teamscale is explained in detail.</p><nav class="table-of-contents"><ul><li><a href="#managing-access-to-global-teamscale-features">Managing Access to Global Teamscale Features</a></li><li><a href="#users-vs-groups-vs-roles">Users vs. Groups vs. Roles</a></li><li><a href="#global-roles">Global Roles</a></li><li><a href="#global-permissions">Global Permissions</a></li><li><a href="#project-roles">Project Roles</a></li><li><a href="#project-permissions">Project Permissions</a></li><li><a href="#basic-roles">Basic Roles</a></li></ul></nav><h2 id="managing-access-to-global-teamscale-features" tabindex="-1">Managing Access to Global Teamscale Features <a class="header-anchor" href="#managing-access-to-global-teamscale-features" aria-label="Permalink to &quot;Managing Access to Global Teamscale Features&quot;">​</a></h2><p>You can control access to several global Teamscale features. Examples include the creation of projects or editing the global e-mail notification settings. To grant access to these features global roles are assigned to users or groups.</p><h2 id="users-vs-groups-vs-roles" tabindex="-1">Users vs. Groups vs. Roles <a class="header-anchor" href="#users-vs-groups-vs-roles" aria-label="Permalink to &quot;Users vs. Groups vs. Roles&quot;">​</a></h2><p>Access right management in Teamscale is based on <em>users</em>, <em>groups</em> and <em>roles</em> assigned to them.</p><ul><li>Each developer using Teamscale needs to have a <strong>user</strong> account</li><li>Users can be tied to multiple <strong>groups</strong>. In order to grant permissions to a user or group members, <em>roles</em> are assigned.</li><li>A <strong>role</strong> represents a set of permissions granted to the user or group members and may have an optional context in which it applies. One such context would be a specific project within which the permissions of a role apply. There are three different kinds of roles: <ul><li><a href="#global-roles">Global roles</a> which grant access to administrative features of Teamscale and creation of new objects like projects or analysis profiles.</li><li><a href="#project-roles">Project roles</a> are assigned to members and define rights the users have within a project. They grant access to different actions available within the project.</li><li><a href="#basic-roles">Basic roles</a> which allow simple view, edit and delete access to access controlled objects like analysis profiles or external accounts. In the following the three different role types and corresponding permissions are explained in detail.</li></ul></li></ul><h2 id="global-roles" tabindex="-1">Global Roles <a class="header-anchor" href="#global-roles" aria-label="Permalink to &quot;Global Roles&quot;">​</a></h2><p>Global roles represent a set of permissions which enable features of Teamscale which are unrelated to a specific object like a project or analysis profile. They can be created, edited and deleted by a user with the global permission to edit roles. See the tables below for global permissions and their meaning. A global role can be assigned to a user or group and grants the global permissions of the role. The role <em>Instance Admin</em> cannot be edited and always includes all global permissions.</p><h4 id="default-global-roles" tabindex="-1">Default Global Roles <a class="header-anchor" href="#default-global-roles" aria-label="Permalink to &quot;Default Global Roles&quot;">​</a></h4><p>The following overview lists the pre-configured default <strong>global</strong> roles of Teamscale.</p><table tabindex="0"><thead><tr><th>Permission</th><th>Description</th></tr></thead><tbody><tr><td><em>Instance Admin</em></td><td>The instance admin has all global permissions.</td></tr><tr><td><em>Instance Technical Quality Engineer</em></td><td>The instance TQE role allows creating quality reports, retrospectives, metric threshold configurations and dashboard templates.</td></tr><tr><td><em>Project Creator</em></td><td>The project creator role allows creating projects, analysis profiles and metric threshold configurations.</td></tr><tr><td><em>User Manager</em></td><td>The user manager allows creating users and groups.</td></tr></tbody></table><h2 id="global-permissions" tabindex="-1">Global Permissions <a class="header-anchor" href="#global-permissions" aria-label="Permalink to &quot;Global Permissions&quot;">​</a></h2><table tabindex="0"><thead><tr><th>Permission</th><th>Description</th></tr></thead><tbody><tr><td><em>Create Projects</em></td><td>Allow creation of new projects. The creator has the project administrator role for the project upon creation.</td></tr><tr><td><em>Create Users</em></td><td>Allow creation of users. The creator has the owner role for the user upon creation.</td></tr><tr><td><em>Create Groups</em></td><td>Allow creation of groups. The creator has the owner role for the group upon creation.</td></tr><tr><td><em>Create Analysis Profiles</em></td><td>Allow creation of analysis profiles. The creator has the owner role for the analysis profile upon creation.</td></tr><tr><td><em>Create Metric Threshold Configurations</em></td><td>Allow creation of metric threshold configurations. The creator has the owner role for the metric threshold configuration upon creation.</td></tr><tr><td><em>Create Quality Reports</em></td><td>Allow creation of quality reports. The creator has the owner role for report upon creation.</td></tr><tr><td><em>Create Retrospectives</em></td><td>Allow creation of retrospectives. The creator has the owner role for retrospective upon creation.</td></tr><tr><td><em>Create External Accounts</em></td><td>Allow creation of new external accounts for repository connectors, issue trackers etc.. The creator has the owner role for the account upon creation.</td></tr><tr><td><em>Access Administrative Services</em></td><td>Allow access to administrative services. Mostly affects debug services.</td></tr><tr><td><em>Admin Dashboards</em></td><td>Allow viewing and editing all dashboards including admin dashboards.</td></tr><tr><td><em>Backup Global Data</em></td><td>Allow backup of global data like users, groups and permissions.</td></tr><tr><td><em>Assign Global Roles</em></td><td>Allow assigning global roles to users or groups.</td></tr><tr><td><em>Edit Roles</em></td><td>Allow editing the permissions of global- and project roles. Note that a role edit affects all role assignments of that role.</td></tr><tr><td><em>View System Status</em></td><td>Allow viewing the system status via the system perspective.</td></tr><tr><td><em>Edit External Metrics Schema</em></td><td>Allow editing the external metrics schema.</td></tr><tr><td><em>Edit External Findings Schema</em></td><td>Allow editing external findings and finding groups.</td></tr><tr><td><em>Edit Global Notification Settings</em></td><td>Allow editing global notification settings.</td></tr><tr><td><em>Edit Server Options</em></td><td>Allow editing server options via the settings page of the admin perspective.</td></tr></tbody></table><h2 id="project-roles" tabindex="-1">Project Roles <a class="header-anchor" href="#project-roles" aria-label="Permalink to &quot;Project Roles&quot;">​</a></h2><p>Project roles represent a customizable set of permissions which are specific to projects. They can be created, edited and deleted by a user with the global permission to edit roles (see tables below). A project role can be assigned to a user or a group for a single project and grants the permissions of the role within the project. Furthermore, a project role can be assigned globally for all projects. Such a global assignment will grant the permissions to the user or group for all projects that exist in Teamscale. The role <em>Project Administrator</em> can&#39;t be edited and always includes all project permissions.</p><h4 id="default-project-roles" tabindex="-1">Default Project Roles <a class="header-anchor" href="#default-project-roles" aria-label="Permalink to &quot;Default Project Roles&quot;">​</a></h4><p>The following <strong>project roles</strong> come pre-configured with Teamscale.</p><table tabindex="0"><thead><tr><th>Permission</th><th>Description</th></tr></thead><tbody><tr><td><em>Project Administrator</em></td><td>Project administrators have all available project permissions for a project. This role is not editable.</td></tr><tr><td><em>Developer</em></td><td>Developers can just view the project.</td></tr><tr><td><em>Project Lead</em></td><td>Project leads may view a project and additionally manage baselines and tasks.</td></tr><tr><td><em>Technical Quality Engineer</em></td><td>Project TQEs may view a project and additionally manage baselines, tasks, architectures and issue queries.</td></tr><tr><td><em>Architect</em></td><td>Architects may view a project and create and edit architectures for it.</td></tr><tr><td><em>Build</em></td><td>Build permissions allow uploading external data and trigger information on commit hooks for a project.</td></tr></tbody></table><h2 id="project-permissions" tabindex="-1">Project Permissions <a class="header-anchor" href="#project-permissions" aria-label="Permalink to &quot;Project Permissions&quot;">​</a></h2><table tabindex="0"><thead><tr><th>Permission</th><th>Description</th></tr></thead><tbody><tr><td><em>View Project</em></td><td>View the project in project-specific perspectives.</td></tr><tr><td><em>Edit Project</em></td><td>Edit the project configuration and pause/start the project analysis.</td></tr><tr><td><em>Delete Project</em></td><td>Delete the project.</td></tr><tr><td><em>Edit Baselines</em></td><td>Create, edit and delete baselines for the project.</td></tr><tr><td><em>Edit Tasks</em></td><td>Create, edit and delete tasks for the project.</td></tr><tr><td><em>Update Task Status</em></td><td>Update the status of a project task.</td></tr><tr><td><em>Mark Red Findings</em></td><td>Mark red findings as tolerated or false positive.</td></tr><tr><td><em>Mark Yellow Findings</em></td><td>Mark yellow findings as tolerated or false positive.</td></tr><tr><td><em>Approve Pending Red Finding Exclusions</em></td><td>Approve or reject pending exclusions of red findings as tolerated or false positive. (Only relevant if the finding <a href="./../ui/findings/#exclusion-approval-workflow">exclusion approval workflow</a> is enabled)</td></tr><tr><td><em>Approve Pending Yellow Finding Exclusions</em></td><td>Approve or reject pending exclusions of yellow findings as tolerated or false positive. (Only relevant if the finding <a href="./../ui/findings/#exclusion-approval-workflow">exclusion approval workflow</a> is enabled)</td></tr><tr><td><em>Edit Architectures</em></td><td>Create, edit and delete architectures for the project.</td></tr><tr><td><em>Edit Issue Metrics</em></td><td>Edit issue metrics of the project.</td></tr><tr><td><em>Perform External Uploads</em></td><td>Perform external uploads to the project.</td></tr><tr><td><em>Trigger Commit Hook</em></td><td>Trigger scheduling a repository update trigger on a commit hook for a repository of the project.</td></tr><tr><td><em>Backup Project Data</em></td><td>Create backups of project data.</td></tr><tr><td><em>Assign Roles</em></td><td>Edit role assignments of the project to grant a set of permissions to other users or group members within the project.</td></tr><tr><td><em>Edit Project Options</em></td><td>Edit project options.</td></tr><tr><td><em>View All User Data</em></td><td>View data from other users in the project in case the data privacy option is enabled.</td></tr></tbody></table><h2 id="basic-roles" tabindex="-1">Basic Roles <a class="header-anchor" href="#basic-roles" aria-label="Permalink to &quot;Basic Roles&quot;">​</a></h2><p>Basic roles can be assigned to users and groups for objects in the following categories:</p><ul><li><p>Analysis Profiles</p></li><li><p>Metric Threshold Configurations</p></li><li><p>External Accounts</p></li><li><p>Groups</p></li><li><p>Users</p></li><li><p>Quality Reports</p></li></ul><p>The rest of this section will use the analysis profiles category as an example. However, the same also applies to objects in the other categories. Each basic role grants a fixed set of permissions to the user or group members (see table below for details). A basic role can be assigned for a single analysis profile to a user or a group and grants the permissions of the role for the analysis profile. Furthermore, a basic role can be assigned globally for all analysis profiles. Such a global assignment will grant the permissions of the role to the user or group for all analysis profiles that exist in Teamscale.</p><h4 id="basic-roles-1" tabindex="-1">Basic Roles <a class="header-anchor" href="#basic-roles-1" aria-label="Permalink to &quot;Basic Roles&quot;">​</a></h4><table tabindex="0"><thead><tr><th>Role</th><th>Description</th></tr></thead><tbody><tr><td><em>Viewer</em></td><td>Only allows viewing the object.</td></tr><tr><td><em>Editor</em></td><td>Allows viewing and editing the object.</td></tr><tr><td><em>Owner</em></td><td>Allows viewing, editing and deleting the object. Furthermore, allows providing access via assignment of roles to other users or groups for the object.</td></tr></tbody></table>',28)])])}const g=t(s,[["render",i]]);export{p as __pageData,g as default};
