import{_ as a}from"./chunks/tga-test-gaps.CGjhZutw.js";import{_ as t,c as s,ak as o,o as i}from"./chunks/framework.CM689eR4.js";const r="/assets/CoverageCommitLayout.iUaLbxs0.png",f=JSON.parse('{"title":"Test Gap Analysis","description":"","frontmatter":{},"headers":[],"relativePath":"reference/test-gap-analysis/index.md","filePath":"reference/test-gap-analysis/index.md"}'),n={name:"reference/test-gap-analysis/index.md"};function h(l,e,c,d,p,m){return i(),s("div",null,[...e[0]||(e[0]=[o('<h1 id="test-gap-analysis" tabindex="-1">Test Gap Analysis <a class="header-anchor" href="#test-gap-analysis" aria-label="Permalink to &quot;Test Gap Analysis&quot;">​</a></h1><p>This article describes the idea and concept of the Test Gap analysis in Teamscale and provides insights into some technical details.</p><h2 id="goal-of-test-gap-analysis" tabindex="-1">Goal of Test Gap Analysis <a class="header-anchor" href="#goal-of-test-gap-analysis" aria-label="Permalink to &quot;Goal of Test Gap Analysis&quot;">​</a></h2><p>Testing is an integral part of a software product’s life-cycle. Some people prefer executing their tests continuously while they develop, others have a separate testing phase before each release. The goal, however, is always the same: finding bugs. The more, the better.</p><p>Research has shown that untested changes are five times more likely to contain errors than other parts of the system (<a href="https://www.cqse.eu/publications/2013-did-we-test-our-changes-assessing-alignment-between-tests-and-development-in-practice.pdf" target="_blank" rel="noreferrer">“Did We Test Our Changes?”, Eder et. al., 2013</a>). It is therefore a good idea to ensure that all changes in your code base are tested at least once. This is true whether you do selective manual tests or execute your whole test suite automatically every night.</p><p>Do you really know what your tests do? Which parts of the system they touch? And do you know exactly what has changed in your system since the last release? Every class, every method that was modified in some way?</p><p>Teamscale&#39;s Test Gap analysis answers this question. The analysis points out untested changes for a given timeframe, for instance, the time since the last release. Usually, this code should receive some more attention before it is released.</p><h2 id="visualization-of-test-gaps-in-teamscale" tabindex="-1">Visualization of Test Gaps in Teamscale <a class="header-anchor" href="#visualization-of-test-gaps-in-teamscale" aria-label="Permalink to &quot;Visualization of Test Gaps in Teamscale&quot;">​</a></h2><p>The main tool for displaying test gaps in Teamscale are treemaps. <img src="'+a+'" alt="Test Gaps on a Treemap" width="1882" height="1113" data-zoom="true"></p><p>You can find an in-depth tutorial on how to interpret these treemaps in <a href="./../../tutorial/working-with-test-gap-treemaps/#reading-test-gap-treemaps">Reading Test Gap Treemaps</a>.</p><h2 id="technical-details" tabindex="-1">Technical Details <a class="header-anchor" href="#technical-details" aria-label="Permalink to &quot;Technical Details&quot;">​</a></h2><p>In this section, we describe some technical details of Teamscale&#39;s Test Gap analysis.</p><h3 id="focus-on-method-granularity" tabindex="-1">Focus on Method Granularity <a class="header-anchor" href="#focus-on-method-granularity" aria-label="Permalink to &quot;Focus on Method Granularity&quot;">​</a></h3><p>The Test Gap analysis in Teamscale works exclusively on method granularity. The analysis considers a method as covered if (and only if) a coverage report marks one or more lines in the method as covered.</p><p>In theory, we could base the Test Gap analysis on a more fine-grained coverage granularity (e.g., line-based). However, using coverable lines as basic entity for the Test Gap analysis would make the concept harder to grasp than using methods.<br> Also, line-based granularity would cause a significant impact on the analysis complexity (run time and memory usage). In our experience, the increased precision does not justify the higher cost. Usually, the method-level granularity analysis yields a clear picture of which code regions have been neglected in testing.</p><h3 id="supplying-coverage-reports-to-teamscale" tabindex="-1">Supplying Coverage Reports to Teamscale <a class="header-anchor" href="#supplying-coverage-reports-to-teamscale" aria-label="Permalink to &quot;Supplying Coverage Reports to Teamscale&quot;">​</a></h3><p>The Test Gap analysis is based on code coverage reports that are generated by external profiling tools. Teamscale does not execute the analyzed code and can therefore not decide which code is executed by tests.</p><p>We support a vast array of coverage-profiling tools for different languages. In <a href="./../../howto/setting-up-profiler-tga/">our guide to profiling</a> you can find the right tool for your technologies.</p><h3 id="coverage-processing-in-project-history" tabindex="-1">Coverage Processing in Project History <a class="header-anchor" href="#coverage-processing-in-project-history" aria-label="Permalink to &quot;Coverage Processing in Project History&quot;">​</a></h3><p>When Teamscale processes a coverage report, it creates an artificial commit in the project history that applies this coverage to the code. Teamscale does not load this commit to the version-control system (git, svn, ...). The artificial commit exists only internally in Teamscale.</p><p>The left side of the following illustration shows a scenario where we upload coverage for a method and change the method afterwards. The right side shows a merge scenario. <img src="'+r+'" alt="Example Commit Graph" width="1714" height="814" data-zoom="true"></p><p>If a coverage commit reports that a method is covered at a given branch/timestamp, we consider this method as covered until its next change. In the scenario on the left side, this means that the method is covered between the coverage commit and the second code commit. Since the second code commit changes the method, it will be marked as untested until new coverage for the method is uploaded.</p><p>In the scenario on the right side, a method is changed and covered on the master branch. With the merge, the method changes from master are applied to the feature branch. Thus, the method is considered as changed after the merge. The coverage from master is merged to the feature branch if (and only if) the method has not been changed with respect to its predecessor on master, i.e., the test coverage from master is still considered as valid after the merge.</p>',23)])])}const y=t(n,[["render",h]]);export{f as __pageData,y as default};
