import{_ as t,c as a,ak as o,o as n}from"./chunks/framework.CM689eR4.js";const i="/assets/sap-transport-import-options.lGqQTEig.png",s="/assets/sap-abap-git-connector.BEyOA11d.png",r="/assets/sap-activate-scov.B1Vs_O_0.png",c="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAVoAAAFMCAMAAAC9AITCAAAAz1BMVEXU1NTq7O729vaZm50sLzNsb3JAREaDhYdWWVzMzc6ws7Teu6roooD5s5H9cC77jlr5q4f26OH+8On87uf77eYncjV5pXz97+ipwaVOi1h6b2puY1/Txr+vop2Ge3a+sauglI+UiIP41MP+/v7////8/Pz9/f3OUlKzAADnqan4+Pjxy8vFNjZsb3FfYmV6fX/P0NCXmZunqKr5+fmJi424ubq7HR1jjr0KSpYeWp+8zuGqxN7D1egfW6AVU5uNr9NmkcE1bquuxt+Apcyeu9iCnW4BAAANqklEQVR4AezXhULAMAwE0JFeFXf+/0tZb4EGd20O7QV982XZYcTz2XFap3Vaj9M6rdN6XqINWBPlLUlZzPcW8TxKm1BFKtDeQZv5XamIROvLldNmVHao76BN8XFMpyVpNIOsh3cKEUC1TU6okgBES3tDWDjQua5S5vdvPyPPR9sQRh/RlUonCnSzTVXJFAdtoKTup2OuK6VtaFIxI20jwBqpaGwqeSTcazQ5Uc3srom0dn6Ptk55QqgIwsRusKVtKuF+sx3wMLRMAzHt3NKSP898ri3bkcsYWttUFLvXGttGzDG3tHriqNPeIVSeEPI92juNHtnR0JZesI/FzJU29hXG989GKwWVsugOzeyV4X5D6ICkar0gJgoxzTwWVW2AjsK0T2Mt4PZyZmjvN0DMqbdJGI6z0LCMOVeSgNJ/SJnx5svjtE7rcVqndVrPY7TLmt29X5Td5U/H0q5v+we/KPvyp+O030h7ePQrcvgPaY+Of0WOnNZpndZp/z3tic2p034e7dnJ+cjFpdN+Iu2Vob1mv95x5AyhIAqv4YSuug/u/jfp4MdSq4WnOx8qIDrRJwL48wOtHABY7IWT15VtA3AO3Bx3ab0A8r+0VcDojVZ9aT/SPmo14ryz3KX9gjaVEG5B225w47TXDoodQgnauGULntPLXpf2RLsK1rTAQfqhLdoAELYHWANSsAY3btDAzG4v7YE2HKhbGzK2XDjYa7tokTOJcgfbc7eX9kBLrRYtWLZPtBBuHJM5YXaQurSfaFOzaNEO4kyLk0lFKIt7a7+mxQ5apGHeadsJjCFLoEpwowQNrNnt/Y0daaegBbLXOy1h2wLC89DjZlz/Xgi/j/Z1f9m7m9y2YSCO4sDse4lY8VfLP02W7P2PVo4GbiU0tYDWBgL7vYUYAaPNLwJjKQHCgy6vZ3ipCC200EILLb8sj/gTD2ihffvyiXp7KlqCFtonCVpood1No3e7d9Dup8NxdJrOdteg3X89Rt9u2iaNsm130SUuKH4syS6qr0n7PWRn290t2uKH9l+0qb8U7e5w/NXpfYO2pn+gjV6Qdjr+7rDfpo2twWL1U0mOqaIyWKXyB626ZSnHBcv51GLiOWnPsR9s7AghFQf3KCnW1uJUZsrmXmb5Squ5mbaOY+5uvJqv8rn6CrQ/btFq1My6/Ew91utpdbY46R/ctV09rlrOB2uXsSEEWtVcrcm8WFJQ1fTRXhuiii9W81aylTZWfoy1HHemt75r++271ka5mPpyPr4NyVc+fJlqbJZdsZY2Ly38lnvtmraVmTZVW89by+mZHxlO1512Om/RFmdLkrv4mmKRBdXfPyHEbFNez1tX5UH3MV3E65kHlQsvFR9SUTYPWoIWWmgJWmihJWihhZaghRZaghZaaAlaaKG9a7SgJf55ALTQQgsttAQttNAStNBCS9BCCy1BCy20BC200P5kxzyUXYdBIDoTrUT5/w9+F+9k7fB8ey9KwwKJ5QxK+xs/Fy3m456vjXYAgL9glwCMlgFAvoQe4tyx7IVoWc3XQGsbk3WnZt4omo/q82vEKkD5lFZqOw8sux+txtNlqZovgXaJyLPRTr5OBDnFc9H6tPWmaFXN10B71epANd7aXnjFCg088mUTJeAMtHY8Fb9sIbanbamXb9TC4M58R0EGu8wcWLcGH1r9v6zZ9q2harSSUrBN+7qdjXdGO0qrGoLa1uSVUCXyEriSLZyurk2ME7QIPjHcva5Ge+OxxVRyyRDaue0zT2RJhta0ava8wRMVGDez79617IRFtKq5o5WQTSBPv9BmR7tR4BPbMhGcGlAe+g1lOLeUcUXLZGeyJGPf91hNzwurVH32vdESD1Xz5AEdbQkuk7oImGhpdrRl8CnBkZw6ok0kV5eLMHaDaJnsTJZk7Pseq+l5Jw9Im31vtCqzVAf8rGt51OIUbX+v7WhTvoZ2skwef0bS6Ggl63G0qqblTUSt0OyHoHUBm34FN1XD3BBIzckbQqEMOnKPF9qA3YeWnoF47A2hy5JHoUKrao55+czOsY9DG2zG6grlHmANpJQAXSyz5tipPnVYs8Jc8UJb4eW01dASy5XwwqCE3ZiHDyufTZY8YJjQqpqWtyyMruZd0eqnFA8NvM49pi1eVa3wku2M0YJ5Idr+a4zxQivnsWu5sz7Ufd25Fj9JZRhqdjNqosmSZ+77HqX0vIR+abO/4j+E9d7H9PnjH3t3odw4DEVheCfGZSZdY9//IddXPmqUDXih3P8UdONRBr7RuNwDLbTQEmih5e/GXr95QHn94lGHKjda8u4/1GZS9kqPLrTQQgvtpzyfob052i+fvu7z7Tu0N0j7I6P9eYE22JLg06Udc/bYxvi2GWin5d2cUQWNShdZbdikDSO0R7RLpnCOKMwr8Ajtv9F21n0czRaxYBY0Hpku6RKt7hS6Y4T1nfVmU04LbbRa2HqLk0bPaAfnd7JEq8dhXed5vTzoCTkttDq8cdKY02qyXrTp8biuSTw9D9pEOy4gk5mJVuPBDaEPcfs1bW8xfR8u0UI7D1FXpzaNnmFY4fp0SvNT6+HUXqSddXP1NfRp1I3BbS3dU8PhvXa0dZ1mf55o+Wos/5JB07S4zDZozHbMaVgW3+Bv8fG4Xg/x8nOhzcMXunx7hm8qQgsttNBCyw/L1/ArHtBCe/X2AeWK8gACLbTQEmihhZZACy20BFqq3KhyI/yNLrTQEmihhZY8BFoCLbTQEmihhZZACy20BFpooSXQQgttq7qF4uar56Btd3GF9sZpW7XJ1Nu0f/d/6KGtWpdq2rZK/Wdam7SkIjUN5avjjeQkbVG7WeG0ajpTdZuWrN+tjlvro43kNO2ufLUQ+XDddPYqL8DKitTKwofyaCM5Q1vF1zZvOlN1mxYVqen4lkcbyTnaovSDG2lf5YW0L7Xsi9Sc1CmPN5JTtH4O6zio6UypGy37IjVdOt54JtBWZaNBTWeqbtOSitT8nWd3tBHSc7R+LOOgprNU3aYlFamt+/yQH20kR7R/EXXR6dZAbpRWbcQv+ZL4JmkVvzNwA+CbitBCS/i7sQdV5fZ7frFvHijS7DAQhjrLI6OSLSQ2573/mR4yapr1/DkbXCxaqWpQM9/ktLV/SLrRbrRX15e6ucXWz6O9/u9Sd1fY2mhXQHv/8Pi00f4WtM/X1y8b7W9B+/rw+PZX0O77WmHWEPwBNdrPn3IltP5Po5VYF21nFNo/LVN8Rf802uvrrzyMiXUttCTZDptkWp19lErLUbKwfLDHOkAFCCJIRiU0Zs6oboSKc9FxRCcAOhgjS1dWfYYgln+JVhzoLDd7AaioUukYTAANYLJT3QGRlv/ZYDxXBAfaozN0XiwSwBXqAKMyBhZGa0y0wRxpWauvM5blSGsIpCY7FQJzN8jY09iOFdVXl0NjmxflKCqjq2xttNCeROQYAeOQnWgrLSfInGc7xeZm3gh0kp9DCxq6nIvOIyKygFHZ4mgbTXBeb1D9MTKm63FKOzDbKTdpTUwRbJ+/1g7ubV40xM6sUdniaOGs+1qX8742eKI90xy8F5GP9pBprlKDEfDPoC13XhQE1NEVYFQmtjZaUI7H6FT1caI90hrqcXu2U40+kI6kfxatk2TMiwKaoyh4ZE7d7yF891Na15Vf6L5fDz3/a2j7b0O7368VkoL/2bOrAoZhAICCBoIWoiL+jQ2+xrzyPQnXhtEOmbcxtIsIrdCiRSu0aNEKLVq0QosWrdCiRSu0aNEKLVq0QosWrdCiRYsWLVqhRYtWaNGiFVq0aIUWLVqhRTt1aNEKLVq0QosWrdCiRdvio9TOaHv/mDYmPSqiHYP22Oe0uei2/A/aUnVbuZ0Q0KKdecWEgNaEoD27VZaeOQzCzpBXBMa+/yUHM1Zx0n1f6UKKqARK4u//s/b7HAgNGe2AXzVYujsUejwp4PcxKex4ZgiAvIA8n+/jz9rR4teTrBW/Wsvy860Vf4EVEqP2MNUgT7JW/B0OhO9g7bNDsYS7mtyBP1/E2kdY24FerxxNcWCmBrQJyVoR6NAFzjL7ZrAPEUpryUw4f8Gry6Z8whZyMpVP4jfheU/LWljADoyUSZ68UmiKUJcs3ClT45zveiC0ucwhMWGXsjZEDblI8ywk0OekusDqSzApxsjUiTqZCbO8uigf0aMiopHP4gwETmvX4Jo/GnzkgbNA3Y2FY1sqc4L3spbDOOhppSz7VnDw4Ulw61toJRg9JPOCV3nv4v/LYWPYIVbil+OW1haRZYaTp1LpkmXRTrw2tne31pBhN0N3ROSrL1ngWrOZ4NZHlEmM1pJ5wavMLnqRiA6zobiIl7N3WOv3WkvdYiFt1LrUnB/z1NbQDuXKrV+fWoLsu+upda5N5jufWt+tHSaqYu0intHkeKa11CsW0vY0mBO8u7WHjNP2hsCho+dcYqezdoGzzEuetX1kGlKrk5mwZXnrorU2/ZNmF/GI7HyStdI5GXWLZdHSTk7Q2jtbewgAXwDa/LNDZ5Is7J8QCG59GdmcCYslfoq5uODs2q1VjP+7n8UjnC93y+z3W2uAQXfdYqmxgZrgHaz9tWGNjxXjz9o3iv5n7buFAJDjX7t2TAUADEIxUEFN1L9IFPCYsl0k3AgfrVM42vhZ7lmupYxWz5yu6t+0sq9Fi1Zo0aJFixatBkqBrcPepS43AAAAAElFTkSuQmCC",d="/assets/sap-scov-repair.xm3a7z4d.png",l="/assets/sap-scov-monitor.D1Efwwyq.png",h="/assets/sap-sci-teamscale-findings-variant.B7VT5RUM.png",p="/assets/sap-sci-teamscale-findings-parameters-v2506.lncVrwP-.png",m="/assets/sap-atc-results.Dl4FYZbP.png",u="/assets/sap-transport-integration-se03.BcowxaIw.png",f="/assets/sap-transport-integration-atc.GHFaTVdh.png",g="/assets/sap-transport-integration-findings.B8pl3Eq9.png",b="/assets/sap-abap-object-basic-infos.M3djwS1W.png",y="/assets/sap-abap-object-release-contract.CLHX9pof.png",I=JSON.parse('{"title":"SAP® Integration","description":"","frontmatter":{},"headers":[],"relativePath":"tutorial/sap-integration/index.md","filePath":"tutorial/sap-integration/index.md"}'),A={name:"tutorial/sap-integration/index.md"};function S(v,e,P,C,T,w){return n(),a("div",null,[...e[0]||(e[0]=[o(`<h1 id="sap®-integration" tabindex="-1">SAP® Integration <a class="header-anchor" href="#sap®-integration" aria-label="Permalink to &quot;SAP® Integration&quot;">​</a></h1><p>Teamscale can integrate with SAP® systems in order to use the analyses provided by Teamscale in the area of ABAP® custom code development. The following is relevant for ABAP developers, quality engineers for ABAP, and SAP NetWeaver® system administrators who want to configure Teamscale, or those of them who want to connect to Teamscale from an SAP system. It covers the SAP and ABAP specific configuration steps and usage scenarios, especially those tasks, which are done within an SAP system. This chapter is irrelevant for all who have nothing to do with custom code development for SAP.</p><div class="info custom-block"><p class="custom-block-title">INFO</p><p>Most of this chapter focuses on how to analyze custom ABAP code using Teamscale Connector for SAP NetWeaver® AS ABAP®. Information on how to use Teamscale with repositories managed by abapGit or gCTS is presented <a href="#git-based-abap-development-gcts-abapgit">at the end of this section</a>.</p></div><div class="warning custom-block"><p class="custom-block-title">SAP Java Connector (SAP JCo)</p><p>A prerequisite for Teamscale to communicate with SAP systems is the SAP Java Connector (SAP JCo) library. SAP&#39;s licensing restrictions do not permit redistribution of this library with Teamscale. However, SAP JCo is licensed without additional fees as part of a licensed SAP solution or component license. To connect Teamscale to your SAP system, you need to manually download the library from SAP and put it into Teamscale&#39;s library folder. For detailed information on the installation process, please refer to <a href="#installation-of-the-sap-java-connector">Installation of the SAP Java Connector (JCo)</a></p></div><div class="tip custom-block"><p class="custom-block-title">SAP Java Connector (SAP JCo) for Cloud-Hosted Instances</p><p>For instances hosted on our cloud platform, the SAP Java Connector (JCo) is automatically included for customers with SAP integrations.</p></div><nav class="table-of-contents"><ul><li><a href="#installation-of-the-sap-java-connector">Installation of the SAP Java Connector</a></li><li><a href="#teamscale-connector-for-sap-netweaver®-as-abap®">Teamscale Connector for SAP NetWeaver® AS ABAP®</a><ul><li><a href="#installation-of-the-sap-connector">Installation of the SAP Connector</a></li><li><a href="#removal-of-the-sap-connector">Removal of the SAP Connector</a></li></ul></li><li><a href="#user-and-role-for-rfc-access">User and Role for RFC Access</a><ul><li><a href="#role-and-required-access-rights">Role and Required Access Rights</a></li><li><a href="#rfc-user-for-teamscale">RFC User for Teamscale</a></li></ul></li><li><a href="#sap-connection-configuration-in-teamscale">SAP Connection Configuration in Teamscale</a><ul><li><a href="#configuring-repository-clone-directory">Configuring Repository Clone Directory</a></li><li><a href="#configuring-sap-abap-system-connection">Configuring SAP ABAP System Connection</a></li><li><a href="#connecting-a-teamscale-project-with-sap">Connecting a Teamscale Project with SAP</a></li></ul></li><li><a href="#background-full-sync">Background Full Sync</a></li><li><a href="#secure-network-communication-optional">Secure Network Communication (optional)</a><ul><li><a href="#snc-configuration-of-the-sap-system">SNC Configuration of the SAP System</a></li><li><a href="#snc-configuration-on-the-teamscale-server">SNC Configuration on the Teamscale Server</a></li></ul></li><li><a href="#additional-analysis-configuration-for-sap">Additional Analysis Configuration for SAP</a><ul><li><a href="#grouping-changes-by-transport-request-or-task">Grouping Changes by Transport Request or Task</a></li><li><a href="#integrating-sap-code-inspector-atc">Integrating SAP Code Inspector / ATC</a></li><li><a href="#selecting-defining-a-code-inspector-check-variant">Selecting/Defining a Code Inspector Check Variant</a></li><li><a href="#code-inspector-settings-in-sap-abap-system-connection">Code Inspector Settings in SAP ABAP System Connection</a></li><li><a href="#test-gap-analysis-set-up-for-sap">Test Gap Analysis Set Up For SAP</a></li><li><a href="#troubleshooting-no-coverage-information">Troubleshooting: No Coverage Information</a></li><li><a href="#using-scov-lite-for-teamscale-and-upl">Using SCOV Lite for Teamscale and UPL</a></li></ul></li><li><a href="#integration-with-abap-development-tools-for-eclipse-adt">Integration with ABAP Development Tools for Eclipse (ADT)</a></li><li><a href="#integration-with-atc">Integration with ATC</a><ul><li><a href="#configuring-https-connection-to-teamscale">Configuring HTTPS Connection to Teamscale</a></li><li><a href="#configuring-connection-settings">Configuring Connection Settings</a></li><li><a href="#test-activation">Test Activation</a></li><li><a href="#definition-of-a-check-variant">Definition of a Check Variant</a></li><li><a href="#execute-the-check-variant">Execute the Check Variant.</a></li></ul></li><li><a href="#integration-with-sap-transport-management-system">Integration with SAP Transport Management System</a></li><li><a href="#teamscale-features-for-sap-abap">Teamscale Features for SAP ABAP</a><ul><li><a href="#properties-of-abap-code-objects">Properties of ABAP Code Objects</a></li></ul></li><li><a href="#git-based-abap-development-gcts-abapgit">Git-based ABAP development (gCTS, abapGit)</a><ul><li><a href="#abapgit">abapGit</a></li><li><a href="#git-based-cts-gcts">Git-based CTS (gCTS)</a></li></ul></li></ul></nav><h2 id="installation-of-the-sap-java-connector" tabindex="-1">Installation of the SAP Java Connector <a class="header-anchor" href="#installation-of-the-sap-java-connector" aria-label="Permalink to &quot;Installation of the SAP Java Connector&quot;">​</a></h2><ol><li>Download the SAP Java Connector (SAP JCo). SAP JCo is available through the <a href="https://support.sap.com/en/product/connectors/jco.html" target="_blank" rel="noreferrer">SAP Service Marketplace</a> for registered SAP customers. Download the most recent version (&gt;= 3.1) for the platform running Teamscale. When SAP JCo is needed for deploying our docker container, use the version for <em>Linux for Intel compatible processors</em>.</li><li>Uncompress the contained library files into a temporary directory.</li><li>Copy the Java library <code>sapjco3.jar</code> and the native library file for the specific platform (<code>sapjco3.dll</code> for Windows, <code>libsapjco3.so</code> for Linux, or <code>libsapjco3.dylib</code> for macOS) to a directory named <code>lib-ext</code>.</li></ol><ul><li>For Teamscale zip distributions, the <code>lib-ext</code> directory must be inside the Teamscale installation directory.</li><li>For Teamscale Docker distributions, the <code>lib-ext</code> directory must be mounted directly in the <code>volumes</code> section of the <code>docker-compose.yml</code> file to the directory <code>/opt/teamscale/lib-ext</code>, see below. Please consider setting the appropriate access rights (see <a href="./../../howto/installing-teamscale/installing-with-docker/#prepare-the-necessary-directories">How to install Teamscale with Docker</a>).</li></ul><div class="language-yaml vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">yaml</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">    volumes</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span></span>
<span class="line highlighted"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      - </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">/path-on-host/lib-ext:/opt/teamscale/lib-ext</span></span></code></pre></div><ol start="4"><li>On Windows systems, please make sure the prerequisite <em>Microsoft Visual Studio C/C++ Runtime</em> is installed. The architecture (x86 or x64) must match your JVM&#39;s architecture. If in doubt, consult the <em>System</em> &gt; <em>System Information</em> view. For details, see <a href="https://me.sap.com/notes/2786882" target="_blank" rel="noreferrer">SAP Note 2786882</a>.</li><li>(Re-)start Teamscale to load the SAP JCo library. You can confirm that the JCo library has been successfully loaded on the <em>System</em> &gt; <em>System Information</em> view.</li></ol><h2 id="teamscale-connector-for-sap-netweaver®-as-abap®" tabindex="-1">Teamscale Connector for SAP NetWeaver® AS ABAP® <a class="header-anchor" href="#teamscale-connector-for-sap-netweaver®-as-abap®" aria-label="Permalink to &quot;Teamscale Connector for SAP NetWeaver® AS ABAP®&quot;">​</a></h2><p>The Teamscale Connector for SAP NetWeaver® AS ABAP® provides the connection between Teamscale and SAP NetWeaver AS ABAP based systems. The connector has to be transported to the SAP NetWeaver system and provides the following main functions:</p><ul><li><p>An RFC-based interface, which is used by Teamscale to poll the SAP system for custom code changes, so they can be analyzed within Teamscale</p></li><li><p>Execution of SAP Code Inspector (SCI) and export of the inspection results to Teamscale</p></li><li><p>Extraction of test coverage and usage data for Teamscale to support <a href="./../../introduction/improving-test-quality/">Test Gap analysis</a> and <a href="./../../introduction/improving-software-quality/#analyzing-feature-usage">usage analysis</a></p></li><li><p>A plug-in for the ABAP Workbench and the Change and Transport System to access Teamscale results from the SAP system. This is realized by a custom SAP Code Inspector test case which shows messages for findings identified in Teamscale.</p></li></ul><p>The Teamscale Connector for SAP NetWeaver® AS ABAP® is compatible with SAP NetWeaver AS ABAP 7.40 EHP8 and later versions.</p><h3 id="installation-of-the-sap-connector" tabindex="-1">Installation of the SAP Connector <a class="header-anchor" href="#installation-of-the-sap-connector" aria-label="Permalink to &quot;Installation of the SAP Connector&quot;">​</a></h3><p>The required configuration steps on the SAP system are independent of clients on the SAP system (in German »mandantenunabhängig«). Therefore, it is not required to transport our add-on to specific clients.</p><p>An archive file containing the latest release of the Teamscale Connector for SAP NetWeaver® AS ABAP® can be downloaded via <a href="https://www.cqse.eu/get-abap" target="_blank" rel="noreferrer">https://www.cqse.eu/get-abap</a>. Download either the <code>.zip</code> or <code>.tar.gz</code> source code file.</p><p>For transport, place the <code>K*</code> and <code>R*</code> files from the archive in the <code>cofiles</code> and <code>data</code> directories of the transport directory of your host machine (typically <code>/usr/sap/trans</code> on Unix/Linux or <code>C:\\usr\\sap\\trans</code> on Windows) and import the transport (transaction <code>STMS</code> ). Enable special conditions <em>Overwrite Originals</em> and <em>Ignore Invalid Component Version</em>:</p><p><img src="`+i+'" alt="SAP Transport Import Options" width="624" height="599" data-zoom="true"></p><p>Basically, no further configuration in the SAP system is required. One exception is the <a href="#snc-configuration-of-the-sap-system">use of Secure Network Communications (SNC)</a>.</p><h3 id="removal-of-the-sap-connector" tabindex="-1">Removal of the SAP Connector <a class="header-anchor" href="#removal-of-the-sap-connector" aria-label="Permalink to &quot;Removal of the SAP Connector&quot;">​</a></h3><p>To remove the Teamscale Connector for SAP NetWeaver® AS ABAP® from your system, a deletion transport is provided upon request. Please contact us, attaching a <a href="./../../howto/creating-support-request/">Teamscale support request</a> and mention the <strong>System ID</strong> the connector should be removed from. We will then provide the deletion transport for the correct version.</p><h2 id="user-and-role-for-rfc-access" tabindex="-1">User and Role for RFC Access <a class="header-anchor" href="#user-and-role-for-rfc-access" aria-label="Permalink to &quot;User and Role for RFC Access&quot;">​</a></h2><p>Teamscale connects to the SAP application server via RFC (remote function call) to retrieve the source code, which should be analyzed as well as some metadata (for example test coverage). The called functions are in function group <code>/CQSE/TEAMSCALE_CONNCT_RFC</code> . Additional functions reside in <code>/CQSE/TEAMSCALE_TIA_RFC</code> . Hence, a (technical) SAP user is required, which will be used by Teamscale to connect to the SAP system. Also, if <a href="https://help.sap.com/docs/ABAP_PLATFORM_NEW/1ca554ffe75a4d44a7bb882b5454236f/" target="_blank" rel="noreferrer">SAP Unified Connectivity</a> (UCON) is used to secure communications, access to these RFC functions must be granted in the UCON configuration.</p><h3 id="role-and-required-access-rights" tabindex="-1">Role and Required Access Rights <a class="header-anchor" href="#role-and-required-access-rights" aria-label="Permalink to &quot;Role and Required Access Rights&quot;">​</a></h3><p>The SAP user for Teamscale must have an appropriate role assigned. The required authorizations are listed here:</p><h4 id="authorizations-for-sap-teamscale-user" tabindex="-1">Authorizations for SAP Teamscale User <a class="header-anchor" href="#authorizations-for-sap-teamscale-user" aria-label="Permalink to &quot;Authorizations for SAP Teamscale User&quot;">​</a></h4><table><tbody><tr><th>Authorization Object</th><th>Field</th><th>Value</th></tr><tr><td><code>S_RFC</code></td><td><code>RFC_TYPE</code></td><td><code>FUGR</code> (Function Group) </td></tr><tr><td></td><td><code>RFC_NAME</code></td><td><code>RFC_METADATA</code>, <code>/CQSE/TEAMSCALE_CONNCT_RFC</code>, <code>/CQSE/TEAMSCALE_TIA_RFC</code></td></tr><tr><td><code>S_RFC</code></td><td><code>RFC_TYPE</code></td><td><code>FUNC</code> (Function Module) </td></tr><tr><td></td><td><code>RFC_NAME</code></td><td><code>DDIF_FIELDINFO_GET</code>, <code>RFCPING</code>, <code>RFC_GET_FUNCTION_INTERFACE</code></td></tr><tr><td><code>S_BTCH_JOB</code></td><td><code>JOBACTION</code></td><td><code>RELE</code> (Release Jobs)</td></tr><tr><td></td><td><code>JOBGROUP</code></td><td><code>*</code></td></tr><tr><td><code>S_COV_ADM</code></td><td><code>ACTVT</code></td><td><code>02</code> (Change)</td></tr><tr><td><code>S_DEVELOP</code></td><td><code>DEVCLASS</code></td><td><code>*</code></td></tr><tr><td></td><td><code>OBJTYPE</code></td><td><code>*</code></td></tr><tr><td></td><td><code>OBJNAME</code></td><td><code>*</code></td></tr><tr><td></td><td><code>P_GROUP</code></td><td><code>*</code></td></tr><tr><td></td><td><code>ACTVT</code></td><td><code>03</code> (Display)</td></tr></tbody></table><p>The authorizations are required for basic RFC access, read access to development objects (source code), scheduling and releasing (own) batch jobs for background processing, and for enabling test coverage analysis.</p><p>The role can be defined manually, e.g. using transaction <code>PFCG</code>, or the predefined role <code>/CQSE/RFC_TEAMSCALE</code> can be used.</p><h3 id="rfc-user-for-teamscale" tabindex="-1">RFC User for Teamscale <a class="header-anchor" href="#rfc-user-for-teamscale" aria-label="Permalink to &quot;RFC User for Teamscale&quot;">​</a></h3><p>The SAP user for Teamscale can be created in the usual way users are crated in the SAP system, e.g. using transaction <code>SU01</code>.</p><div class="warning custom-block"><p class="custom-block-title">WARNING</p><p>Use a <strong>system user</strong>, not a dialog user. The role described before (e.g., <code>/CQSE/RFC_TEAMSCALE</code>) must be assigned to this user.<br><small>Using a dialog user might result in connection timeouts as dialog connections are by default terminated after 10 minutes without user interaction. The initial extraction of the source as well as the retrieval of SAP Code Inspector results might take longer</small></p></div><div class="warning custom-block"><p class="custom-block-title">Time Zone Settings</p><p>It is highly recommended that the user time zone of the SAP user for Teamscale is the same as the SAP system time zone. If the user time zone differs from the system time zone, the continuous polling for code changes might not work correctly, and code changes might not be visible or only with a longer delay. The time zone setting of the user can be checked / edited in transaction <code>SU01</code> .</p><p>Additionally, it is highly recommended that the system time zone in SAP NetWeaver is the same as the time zone of the operating system.</p></div><h2 id="sap-connection-configuration-in-teamscale" tabindex="-1">SAP Connection Configuration in Teamscale <a class="header-anchor" href="#sap-connection-configuration-in-teamscale" aria-label="Permalink to &quot;SAP Connection Configuration in Teamscale&quot;">​</a></h2><p>This section describes the basic configuration to configure a SAP connection.<br> The settings need to be done in the web interface of Teamscale. For configuration, switch to the <em>Admin</em> &gt; <em>Settings</em> view.</p><h3 id="configuring-repository-clone-directory" tabindex="-1">Configuring Repository Clone Directory <a class="header-anchor" href="#configuring-repository-clone-directory" aria-label="Permalink to &quot;Configuring Repository Clone Directory&quot;">​</a></h3><p>First, you should check if a suiting directory is specified in section <a href="./../../reference/admin-settings/git/#repository-clone-directory"><em>Git</em> &gt; <em>Repository Clone Directory</em></a>. Teamscale will save the (historized) code exports in subdirectories of this directory and access them for analysis there. Under the hood, this is realized by a local Git repository which is managed by Teamscale automatically. Usually, the Teamscale repository clone directory will be specified by the system administrator of the Teamscale server, you should check with them to define the proper location. It can be specified as absolute or relative path and defaults to a folder named <code>repo</code> within the JVM process working directory. In case of a relative path, the location is relative to the parent of the Teamscale storage directory (parameter <code>database.directory</code> of the <code>teamscale.properties</code> <a href="./../../reference/administration-ts-installation/">configuration file</a>.)</p><h3 id="configuring-sap-abap-system-connection" tabindex="-1">Configuring SAP ABAP System Connection <a class="header-anchor" href="#configuring-sap-abap-system-connection" aria-label="Permalink to &quot;Configuring SAP ABAP System Connection&quot;">​</a></h3><p>Under <em>SAP</em> &gt; <em>SAP ABAP System Connection</em>, the parameters to connect to an SAP NetWeaver system must be specified. For every SAP system, a separate connection configuration must be added. To add a new connection, press the <i class="plus icon"></i><code>Add</code> button. In the opening dialog, a unique connection ID must be specified, for example the three letter SAP system ID could be used. After this, a new configuration section is added, in which the parameters must be specified.</p><p>The first options are the parameters for the RFC connection. The required parameters mainly depend on the connection type, i.e. if the connection to the SAP system is direct or via logon balancing. Further options specify the logon data (client, user, password). This table describes these parameters:</p><h4 id="system-and-logon-parameters-for-sap-connection" tabindex="-1">System and Logon Parameters for SAP Connection <a class="header-anchor" href="#system-and-logon-parameters-for-sap-connection" aria-label="Permalink to &quot;System and Logon Parameters for SAP Connection&quot;">​</a></h4><table><tbody><tr><td><strong>Direct connection: Application server host</strong></td><td>Mandatory parameter for <strong>direct connection</strong>: The full qualified host name of the SAP NetWeaver application server, e.g., <code>saphost.me.com</code></td></tr><tr><td><strong>Direct connection: Instance number</strong></td><td>Mandatory parameter for <strong>direct connection</strong>: The instance number (formerly called <i>system number</i>) of the SAP NetWeaver application server, e.g., <code>00</code></td></tr><tr><td><strong>System ID</strong></td><td>Mandatory parameter for <strong>logon balancing connection</strong>: 3-letter SAP system ID, e.g., <code>NSP</code></td></tr><tr><td><strong>Logon balancing connection: SAP message server</strong></td><td>Mandatory parameter for <strong>logon balancing connection</strong>: Host name of SAP message server</td></tr><tr><td><strong>Logon balancing connection: Group of SAP application servers</strong></td><td>Mandatory parameter for <strong>logon balancing connection</strong>: Group of SAP NetWeaver application servers (e.g., <code>public</code>)</td></tr><tr><td><strong>Logon balancing connection: SAP message server port</strong></td><td>Optional parameter for <strong>logon balancing connection</strong>: Port of message server, typically <code>36xx</code> where xx refers to the instance number</td></tr><tr><td><strong>SAP Router string</strong></td><td>Optional parameter for connection to systems behind an SAP Router: SAP router string contains the chain of SAP routers and their port numbers and has the form <code>(\\H\\&lt;host&gt;[\\S\\&lt;port&gt;])+</code></td></tr><tr><td><strong>SAP client</strong></td><td>Mandatory parameter: Defines the client used for logon (e. g. <code>001</code>)</td></tr><tr><td><strong>Logon user for password-based authentication</strong></td><td>Mandatory parameter for password-based authentication: The <a href="#user-and-role-for-rfc-access">SAP username which should be used by Teamscale</a></td></tr><tr><td><strong>Logon password for password-based authentication</strong></td><td>Mandatory parameter for password-based authentication: Password of the user</td></tr></tbody></table><p>Further options of the <em>SAP ABAP System Connection</em> parameters control the code retrieval of Teamscale from the SAP system. These specify which code should be retrieved, how often it should be updated and if other result data should be included (e.g., test coverage data). This table describes these parameters. The most important parameters specify which objects should be retrieved and schedule the update intervals.</p><h4 id="sap-object-selection-parameters" tabindex="-1">SAP Object Selection Parameters <a class="header-anchor" href="#sap-object-selection-parameters" aria-label="Permalink to &quot;SAP Object Selection Parameters&quot;">​</a></h4><p><small>See also: <a href="#parameters-for-sap-code-inspector-execution-during-code-retrieval">Code Inspector Options</a></small></p><table><tbody><tr><td><strong>Include objects in default custom namespaces</strong></td><td>Specifies if ABAP source code objects within the default custom namespaces <code>Y... / Z...</code> should be retrieved by Teamscale.</td></tr><tr><td><strong>Further custom namespaces</strong></td><td>Comma-separated list of further custom namespaces like <code>/ABC/, /DEF/</code> for which ABAP code should be retrieved.</td></tr><tr><td><strong>Polling schedule for changes </strong></td><td>Defines in which interval continuous code changes are retrieved from the SAP system. </td></tr><tr><td><strong>Polling schedule for full sync</strong></td><td>Defines in which interval a full synchronization of the code base is performed. </td></tr><tr><td><strong>Use background job for full sync</strong></td><td>If enabled, full sync is scheduled in the background.</td></tr><tr><td><strong>Include objects in ABAP Dictionary (DDIC)</strong></td><td>In addition to ABAP source code, this will also retrieve DDIC objects (table definitions, data elements etc.) in the given namespace(s), e.g. for use in architecture analysis.</td></tr><tr><td><strong>Include all objects with modifications</strong></td><td>In addition to ABAP custom code, this will also retrieve modified ABAP standard objects.</td></tr><tr><td><strong>Include programs generated from BW objects</strong></td><td>On SAP BW systems, this will also retrieve ABAP programs generated from BW transformations, queries, and DTPs in the given namespace(s).<br><small>This is used for test gap analysis.</small></td></tr><tr><td><strong>Include package information for standard objects</strong></td><td>During full sync, this will retrieve package information for all ABAP and DDIC objects on the system. This is useful for analyzing dependencies to SAP standard packages.</td></tr><tr><td><strong>Include code coverage in full sync</strong></td><td>This will retrieve procedure execution information recorded by SCOV on the system. If not enabled already, Teamscale will attempt to start SCOV automatically.</td></tr><tr><td><strong>Include code coverage with change polling</strong></td><td>This may result in very high disk space consumption and long processing time. Especially, this option should not be enabled in combination with very frequent incremental change polling, e.g. every 10 minutes. Further, it should not be enabled when immediate analysis results in SAP or Eclipse ADT are desired, e.g. when using Teamscale during transport release.</td></tr><tr><td><strong>Clear table COVRES after coverage retrieval</strong></td><td>If enabled, the table <code>COVRES</code> which holds coverage data will be cleared after retrieving the coverage data.</td></tr></tbody></table><p>Additional parameters are required for secure RFC communication using <em>Secure Network Communications (SNC)</em>, see <a href="#snc-configuration-of-the-sap-system">here</a>. Together with the ABAP code retrieval from the SAP system also the execution of SAP Code Inspector checks in the SAP system can be performed. The Code Inspector configuration in <a href="#code-inspector-settings-in-sap-abap-system-connection">explained here</a>.</p><h4 id="namespace-configuration" tabindex="-1">Namespace Configuration <a class="header-anchor" href="#namespace-configuration" aria-label="Permalink to &quot;Namespace Configuration&quot;">​</a></h4><p>The namespace parameters <em>Include objects in default custom namespaces</em> and <em>Further custom namespaces</em> specify which code objects should be retrieved from the SAP system. It is recommended to specify all custom namespaces, which are available for development, e.g., enable the retrieval of the default custom namespaces <code>Y</code> and <code>Z</code> as well as all further custom namespaces e.g. <code>/ABC/</code> which are registered for your organization. Note that these parameters only define for which code Teamscale keeps track of the change history, but not which code gets analyzed. The actual selection of the analyzed code is specified in the <a href="./../../reference/ui/project/project/#creating-a-project">project configuration</a>).</p><h4 id="update-intervals" tabindex="-1">Update Intervals <a class="header-anchor" href="#update-intervals" aria-label="Permalink to &quot;Update Intervals&quot;">​</a></h4><p>The scheduling parameters <em>Polling schedule for changes</em> and <em>Polling schedule for full sync</em> define when code (and further data, e.g. coverage results) is retrieved from the SAP system.</p><p><em>Change polling</em> only retrieves objects that have changed since the last retrieval, thus the amount of transferred data is low and the execution time is very short (a few seconds only). A change to an object is only observed once the object gets activated. Here, intervals between 10 and 30 minutes are recommended. Longer intervals may result in an unwanted long delay of analysis results after activation of code changes, shorter intervals may lead to a too fine-grained change history.</p><p>The <em>full sync</em> interval controls when retrieval of all code objects (within the specified namespaces) is performed. Usually, no code changes are visible after synchronization. In rare cases, however, the code base can change without Teamscale&#39;s change polling recognizing it. Such missed changes are typically not caused by regular development, but may result from special transport or upgrade activities. A regular full sync ensures that the code repository created by Teamscale is in sync with the actual code within the SAP system. We recommend a daily update during night.</p><p>Both intervals are specified as <a href="https://en.wikipedia.org/wiki/Cron" target="_blank" rel="noreferrer">cron</a> expressions, for example <code>*/10 * * * *</code> specifies an update of every 10 minutes, <code>0 1 * * *</code> a nightly update at 1:00am. When saving a new SAP connection, an initial full sync will be scheduled automatically. Depending on the amount of code in the system, and other parameters, it will take some minutes until the code is available for analysis in Teamscale.</p><h4 id="asynchronous-communication" tabindex="-1">Asynchronous Communication <a class="header-anchor" href="#asynchronous-communication" aria-label="Permalink to &quot;Asynchronous Communication&quot;">​</a></h4><p>The full sync can be also configured to be executed as a background job of the SAP system. Use this mode if the run-time of the code retrieval takes too long time. This is configured by the setting <em>Execute full update asynchronously</em> and its dependent options. Please refer to the <a href="#background-full-sync">detailed description</a> for more information.</p><h4 id="archiving-of-raw-export-files" tabindex="-1">Archiving of Raw Export Files <a class="header-anchor" href="#archiving-of-raw-export-files" aria-label="Permalink to &quot;Archiving of Raw Export Files&quot;">​</a></h4><p>When receiving data from the SAP system, Teamscale archives the raw data as zip files in a directory on the Teamscale server. These archived files can be used to investigate problems. To preserve disk space, Teamscale will retain archived files only for one year. This period can be configured with the JVM option <code>-Dcom.teamscale.abap.archivingPeriodInDays=365</code> (default value is 365) in the <code>jvm.properties</code> <a href="./../../reference/administration-ts-installation/#jvm-arguments">configuration file</a>.</p><h3 id="connecting-a-teamscale-project-with-sap" tabindex="-1">Connecting a Teamscale Project with SAP <a class="header-anchor" href="#connecting-a-teamscale-project-with-sap" aria-label="Permalink to &quot;Connecting a Teamscale Project with SAP&quot;">​</a></h3><p>After the SAP system connection is specified and the code retrieval was executed for the first time, projects for analyzing the ABAP code of the respective SAP NetWeaver system can be created.</p><p>The creation of projects follows the standard <a href="./../../reference/ui/project/project/#creating-a-project">project configuration</a>, using the ABAP connector and an ABAP-specific analysis profile.</p><h4 id="abap-connector-configuration" tabindex="-1">ABAP Connector Configuration <a class="header-anchor" href="#abap-connector-configuration" aria-label="Permalink to &quot;ABAP Connector Configuration&quot;">​</a></h4><p>Technically, Teamscale creates an ABAP repository directory inside the Teamscale repository clone directory. This directory contains a Git repository for every SAP system. To connect projects with these git repositories, we recommend to use our specific ABAP connector. In comparison to the plain Git connector, the ABAP connector simplifies selection of an SAP connection by providing a dropdown list that includes all available connections. Additionally, the ABAP connector is reduced to the essential configuration options. For example, the <code>Default branch</code> option from the Git connector is missing, as ABAP Git repositories do not use branching.</p><p><img src="'+s+`" alt="ABAP Connector Configuration" width="629" height="596" data-zoom="true"></p><p>Note that the settings to include/exclude source code are specified using the parameters <em>Included file names</em> and <em>Excluded file names</em>, which refer to the file paths within the internal Git repository of the ABAP source code. The path consists of the full package hierarchy and source code files suffixed with <code>.abap</code>. Furthermore, the slashes at custom namespaces are replaced by an exclamation mark, thus <code>/XYZ/</code> is replaced with <code>!XYZ!</code>. This tables states some examples of patterns for including and excluding ABAP source code.</p><h4 id="examples-for-abap-code-file-include-exclude-patterns" tabindex="-1">Examples for ABAP Code File Include/Exclude Patterns <a class="header-anchor" href="#examples-for-abap-code-file-include-exclude-patterns" aria-label="Permalink to &quot;Examples for ABAP Code File Include/Exclude Patterns&quot;">​</a></h4><table><tbody><tr><td>Pattern</td><td>Matched ABAP Source Code Objects </td></tr><tr><td><code>**.abap</code></td><td>All ABAP source code objects in configured namespaces (<code>**</code> matches any path) </td></tr><tr><td><code>$*/**.abap</code></td><td>ABAP source code within local packages (starting with <code>$</code>), <code>*</code> matches all but the path/package separator slash</td></tr><tr><td><code>ZPACKAGE/**.abap</code></td><td>Objects within the top-level package <code>ZPACKAGE</code> and its sub-packages only. Will <strong>not</strong> match if <code>ZPACKAGE</code> has a super package </td></tr><tr><td><code>**/ZPACKAGE/**.abap</code></td><td>Objects within the package <code>ZPACKAGE</code> and its sub-packages only, regardless if <code>ZPACKAGE</code> is a top-level package </td></tr><tr><td><code>**/!XYZ!*/**.abap</code></td><td>Objects within packages in namespace <code>/XYZ/</code> only </td></tr><tr><td><code>!XYZ!ROOT_PACKAGE/**.abap</code></td><td>Objects within the top-level package <code>/XYZ/ROOT_PACKAGE</code> and its sub-packages only </td></tr><tr><td><code>**/PROG/*.abap</code></td><td>Programs and program includes only</td></tr><tr><td><code>**/FUGR/**.abap</code></td><td>Function groups only </td></tr><tr><td><code>**/FUGR/ZSOME_FUGR/*.abap</code></td><td>Function group <code>ZSOME_FUGR</code> only </td></tr><tr><td><code>**/CLAS/**.abap</code></td><td>Global classes only </td></tr><tr><td><code>**/CLAS/!XYZ!CL_BASE_**.abap</code></td><td>Global classes whose name starts with <code>/XYZ/CL_BASE_</code> only </td></tr><tr><td><code>**/CLAS/*/*CCAU.abap</code></td><td>ABAPUnit test classes only (class addition suffixed with <code>CCAU</code>) </td></tr><tr><td><code>**/INTF/**.abap</code></td><td>Global interfaces only </td></tr></tbody></table><h4 id="abap-dictionary-ddic-objects" tabindex="-1">ABAP Dictionary (DDIC) objects. <a class="header-anchor" href="#abap-dictionary-ddic-objects" aria-label="Permalink to &quot;ABAP Dictionary (DDIC) objects.&quot;">​</a></h4><p>Besides the ABAP source code in <code>*.abap</code> files, also textual representations of objects defined in the <em>ABAP Dictionary (DDIC)</em> are retrieved from the SAP system. These dictionary objects are stored in <code>*.abap_ddic</code> files. Adding these files to the project will allow to identify dependencies from ABAP source code to ABAP dictionary objects and between dictionary objects when performing architecture conformance analysis. The textual representation of structures and database tables is the same as used in the source code-based editors of the ABAP Development Tools for Eclipse (available from SAP NetWeaver 7.51 or 7.52 on, respectively). For older SAP NetWeaver versions and further dictionary objects, a similar notation is used in Teamscale. As in Teamscale the only purpose of the dictionary objects is to perform architecture conformance analysis, <code>.abap_ddic</code> files will only contain the required information to identify dependencies and omit further attributes.</p><p>This table contains typical examples for including and excluding ABAP Dictionary objects:</p><h4 id="examples-for-abap-dictionary-file-patterns" tabindex="-1">Examples for ABAP Dictionary File Patterns <a class="header-anchor" href="#examples-for-abap-dictionary-file-patterns" aria-label="Permalink to &quot;Examples for ABAP Dictionary File Patterns&quot;">​</a></h4><table><tbody><tr><td>Pattern</td><td>Matched ABAP Dictionary Objects </td></tr><tr><td><code>**.abap_ddic</code></td><td>All ABAP Dictionary objects in configured namespaces (<code>**</code> matches any path) </td></tr><tr><td><code>**/DOMA/*.abap_ddic</code></td><td>Domains</td></tr><tr><td><code>**/DTEL/*.abap_ddic</code></td><td>Data elements </td></tr><tr><td><code>**/STRU/*.abap_ddic</code></td><td>Data structures </td></tr><tr><td><code>**/TABL/*.abap_ddic</code></td><td>Database tables </td></tr><tr><td><code>**/TTYP/*.abap_ddic</code></td><td>Table types </td></tr><tr><td><code>**/VIEW/*.abap_ddic</code></td><td>Database views </td></tr></tbody></table><p>Of course, these path patterns can also be combined with package specifications, similar to the ABAP source code files. The include/exclude pattern for dictionary objects must be added to the list of include/exclude patterns besides the patterns for the ABAP code.</p><h2 id="background-full-sync" tabindex="-1">Background Full Sync <a class="header-anchor" href="#background-full-sync" aria-label="Permalink to &quot;Background Full Sync&quot;">​</a></h2><p>By default, all updates of the ABAP code are retrieved from the SAP system by <strong>synchronous</strong> communication. The full synchronization, which retrieves the entire code of the configured namespaces, can be alternatively configured to use <strong>asynchronous</strong> communication, i.e. run in the background on the SAP system.</p><p>Background processing is used to avoid a long run-time of the RFC session, which would block other jobs within Teamscale and/or result in communication timeouts. A long run-time is to expect especially if SAP Code Inspector check execution is configured.</p><p>To achieve background processing of the full sync, a batch (BTC) job is scheduled and released in the SAP system. Jobs are monitored in transaction <code>SM37</code>. It only requires that the RFC user for Teamscale is authorized for <code>RELE</code> (release) activity at authorization object <code>S_BTCH_JOB</code>.</p><p>In background processing mode, a full synchronization will initially only schedule a background job in the SAP system. Teamscale is not waiting for the job to finish and closes the connection to the SAP system immediately after scheduling the job. The collection of the source code and meta-data and especially the execution of SAP Code Inspector is then executed in the background on the SAP system. When the background job finishes, the results will be stored in a database table. For retrieving the results, Teamscale is polling the SAP system regularly to check whether the scheduled job is finished and results are available. If so, the result data is retrieved from the SAP system and Teamscale&#39;s internal ABAP repository is updated.</p><p>Change polling, which only queries changed objects, is always scheduled in synchronous communication mode. Also, initial code retrieval is done synchronously but will not execute SAP Code Inspector to make the entire code base visible in Teamscale without a too long delay.</p><h4 id="background-full-sync-configuration-in-teamscale" tabindex="-1">Background Full Sync Configuration in Teamscale <a class="header-anchor" href="#background-full-sync-configuration-in-teamscale" aria-label="Permalink to &quot;Background Full Sync Configuration in Teamscale&quot;">​</a></h4><p>The main configuration in Teamscale is made by the option <em>Use background job for full sync</em> of the <em>SAP ABAP System Connection</em> settings. This will schedule batch jobs in the SAP system to perform the full sync.</p><p>The scheduling interval of the polling job for retrieving the finished results can be specified in the <em>SAP ABAP System Connections - Global Settings</em> of the <em>Admin</em> &gt; <em>Settings</em> in field <em>Schedule for requesting results of asynchronous ABAP exports</em>. In addition, these global options control for how long scheduled jobs are polled from Teamscale if no results could be retrieved for a long time. This is configured with the parameter <em>Maximum wait time</em>.</p><h2 id="secure-network-communication-optional" tabindex="-1">Secure Network Communication (optional) <a class="header-anchor" href="#secure-network-communication-optional" aria-label="Permalink to &quot;Secure Network Communication (optional)&quot;">​</a></h2><p>If the RFC communication between Teamscale and SAP NetWeaver should be secured (encrypted), Teamscale can connect to the SAP system via <em>Secure Network Communications (SNC)</em>. In order to use it, a respective configuration of the SAP system and the Teamscale server is required.</p><h3 id="snc-configuration-of-the-sap-system" tabindex="-1">SNC Configuration of the SAP System <a class="header-anchor" href="#snc-configuration-of-the-sap-system" aria-label="Permalink to &quot;SNC Configuration of the SAP System&quot;">​</a></h3><p>To enable SNC, the SAP system must be configured accordingly. In the following a rough outline of the configuration is stated. As the configuration steps vary depending on the SAP version and on the individual configuration needs for a customer SAP system, please refer to <a href="https://help.sap.com/viewer/e73bba71770e4c0ca5fb2a3c17e8e229/7.51.2/en-US/e656f466e99a11d1a5b00000e835363f.html" target="_blank" rel="noreferrer">this article on help.sap.com</a> for detailed instructions on how to set up SNC. Furthermore, there is a very helpful <a href="https://blogs.sap.com/2006/09/29/setup-data-encryption-between-rfc-client-and-web-as-abap-with-snc/" target="_blank" rel="noreferrer">SAP Community blog post</a>.</p><p>The recommended SNC configuration steps for an SAP NetWeaver system are as follows:</p><ol><li><p>Ensure that the following instance parameters (transaction <code>RZ10</code> ) are set:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>snc/enable = 1</span></span>
<span class="line"><span>snc/identity/as = snc_name</span></span></code></pre></div><p>where <em>snc_name</em> is the SNC name of the SAP system, something like <code>p:CN=SID, O=ACompany, C=EN</code> .</p></li><li><p>The <em>SAP Cryptographic Library</em> must be installed, see <a href="https://me.sap.com/notes/1848999" target="_blank" rel="noreferrer">SAP Note 1848999</a>.</p></li><li><p>With the command line tool <code>sapgenpse</code> of SAP Cryptographic Library, a <em>Personal Security Environment</em> (PSE, stored in a file) for Teamscale must be created. This can be done by executing <code>sapgenpse</code> on the application server (or any other sever where the SAP Cryptographic Library is available). For example, enter the following command:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>sapgenpse gen_pse -v -p teamscale.pse</span></span></code></pre></div><p>During creation of the PSE, the tool will ask for the name of the PSE owner, here the SNC name for Teamscale should be supplied (something like <code>p:CN=TEAMSCALE, O=ACompany, C=EN</code> ). Afterwards, the client certificate (<code>*.crt</code> file) must be exported, again by using <code>sapgenpse</code>:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>sapgenpse export_own_cert -v teamscale.pse -o TEAMSCALE.crt</span></span></code></pre></div><p>This file contains the X.509 client certificate which can be also used for logon instead of username and password, see below.</p></li><li><p>In transaction <code>STRUST</code> the following configuration is required:</p><ul><li><p>The PSE <em>SNC (SAPCryptolib)</em> must have been created. A respective entry should already exist after the SNC instance parameters were set and the SAP system was restarted. The SNC name should be the same as specified in <code>snc/identity/as</code></p></li><li><p>The client certificate created previously (e.g. <code>TEAMSCALE.crt</code> ) must be imported and added to the PSE <em>SNC (SAPCryptolib)</em>. <em>Base64</em> file format should be used.</p></li><li><p>The own (server) certificate of <em>SNC (SAPCryptolib)</em> must be exported to a file, e.g. <code>SNC.crt</code> (again, use <em>Base64</em> file format).</p></li></ul></li><li><p>The server certificate (e.g. <code>SNC.crt</code> ) must be imported in the client PSE file (e.g. <code>teamscale.pse</code> ) and the credentials file <code>cred_v2</code> , which will be used on the Teamscale server, must be created from the client PSE file. For both steps, again the command line tool <code>sapgenpse</code> is used, see the following examples:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>sapgenpse maintain_pk -v -a SNC.crt -p teamscale.pse</span></span>
<span class="line"><span>sapgenpse seclogin -p teamscale.pse -O root</span></span></code></pre></div></li><li><p>The Access Control List (ACL) for SNC restrictions must allow RFC communication with the client: In view <code>VSNCSYSACL</code> (transaction <code>SM30</code> ), an entry for work area <em>external (E)</em> with the SCN name of the client (Teamscale), e.g. <code>p:CN=TEAMSCALE, O=ACompany, C=EN</code>, must be added.</p></li><li><p>If you want to use the client X.509 certificate also for logon instead of username and password, the certificate must be mapped to the SAPTeamscale user. To do so, an entry in view <code>VUSREXTID</code> (transaction <code>SM30</code> ) must be added, again for the SNC name of the client.</p></li></ol><h3 id="snc-configuration-on-the-teamscale-server" tabindex="-1">SNC Configuration on the Teamscale Server <a class="header-anchor" href="#snc-configuration-on-the-teamscale-server" aria-label="Permalink to &quot;SNC Configuration on the Teamscale Server&quot;">​</a></h3><div class="tip custom-block"><p class="custom-block-title">SNC Configuration for Cloud-Hosted Instances</p><p>For instances hosted on our cloud platform, please send the PSE to the Teamscale support team at <a href="mailto:support@teamscale.com" target="_blank" rel="noreferrer">support@teamscale.com</a>. We&#39;ll handle the rest of the configuration.</p></div><p>On the Teamscale server, the following configuration steps are required:</p><ol><li><p>The library files from <em>SAP Cryptographic Library</em> must be saved on the Teamscale server. <em>SAP Cryptographic Library</em> can be downloaded from <a href="https://me.sap.com/" target="_blank" rel="noreferrer">SAP for Me</a> (requires login) for the required operating system, search for <code>COMMONCRYPTOLIB 8</code>. Two files must be present among the library files:</p><ul><li>Credential management binary <code>sapgenpse</code>: This is used by Teamscale for creating the <code>cred_v2</code> credentials and managing the PSE entries inside it.</li><li>Core SNC OS library: For Unix systems it is <code>libsapcrypto.so</code> and <code>sapcrypto.dll</code> for Windows. The path to this file must be set in the systems environment variable <code>SNC_LIB</code>.</li></ul><p>Note that for Teamscale docker instances, the folder location of the library files has to be mounted to the docker container path <code>/opt/teamscale/lib-ext</code>. Also <code>SNC_LIB</code> is automatically set.</p></li><li><p>The environment variable <code>SECUDIR</code> must be set to a directory on the server that would contain the <code>cred_v2</code> credentials file and the PSE files of all SAP systems. The <code>cred_v2</code> should be only accessible for the operating system user running Teamscale. Note that for Teamscale docker instances:</p><ul><li><code>SECUDIR</code> is automatically set to <code>/var/teamscale/snc-cred</code> so ensure that the location of the PSE and <code>cred_v2</code> files on the host operating system is mounted to it.</li><li>If the host operating system is Unix-based, the PSE files should be owned by a user with id <code>1000</code>. This matches the <code>teamscale</code> docker container user and ensures that credential management operations don&#39;t fail from permission issues.</li></ul><p>For ease of management, each PSE file should be named after its SAP system name, which should have a corresponding connection in Teamscale. For instance, a SAP system XYZ should have its connection settings in Teamscale named XYZ and an XYZ.pse file.</p></li><li><p>If the X.509 client certificate should be used for logon (SSO mechanism), the client certificate file (e.g. <code>TEAMSCALE.crt</code> ) must be saved on the Teamscale server.</p></li></ol><h4 id="snc-configuration-in-teamscale" tabindex="-1">SNC Configuration in Teamscale <a class="header-anchor" href="#snc-configuration-in-teamscale" aria-label="Permalink to &quot;SNC Configuration in Teamscale&quot;">​</a></h4><p>Teamscale since v2025.3 can perform PSE and credential management functions through <code>sapgenpse</code>. For this to work on Teamscale non-docker instances installed as a Windows or Unix service, set the operating system username running Teamscale into the JVM property <code>com.teamscale.abap.snc.credentials-user</code>. For docker instances, this is automatically set. To allow auto-determination of the current operating system user, avoid setting the property.</p><p>At start-up, Teamscale auto-creates a <code>cred_v2</code> file from all available SAP system PSEs. This is controlled by the JVM boolean property <code>com.teamscale.abap.snc.create-credentials-at-startup</code>. On Teamscale&#39;s web interface, click Admin &gt; Settings &gt; Manage ABAP SNC Credentials, for more management actions.</p><p>On the <em>Admin</em> &gt; <em>Settings</em> view, you may specify the path to the directory containing the library files of <em>SAP Cryptographic Library</em> under <em>SAP</em> &gt; <em>[SAP ABAP System Connections - Global Settings]</em>.</p><p>Under <em>SAP ABAP System Connection</em>, SNC must be enabled and the SNC options must be specified:</p><h4 id="snc-parameters-for-sap-connection-overview" tabindex="-1">SNC Parameters for SAP Connection Overview <a class="header-anchor" href="#snc-parameters-for-sap-connection-overview" aria-label="Permalink to &quot;SNC Parameters for SAP Connection Overview&quot;">​</a></h4><table><tbody><tr><td><strong>Use Secure Network Communications (SNC)</strong></td><td>Tick to enable SNC</td></tr><tr><td><strong>SNC name of the communication partner server</strong></td><td>The SNC name of the SAP system, something like <code>p:CN=SNC, O=ACompany, C=EN</code></td></tr><tr><td><strong>Own SNC name of the caller</strong></td><td>The client SNC name of Teamscale, something like <code>p:CN=TEAMSCALE, O=ACompany, C=EN</code></td></tr><tr><td><strong>Use SNC Single sign-on (SSO)</strong></td><td>Enable logon by X.509 certificate instead of username/password</td></tr><tr><td><strong>Path to X.509 certificate</strong></td><td>Path to <code>*.crt</code> file holding the X.509 client certificate, only required if SSO mechanism is enabled</td></tr></tbody></table><h2 id="additional-analysis-configuration-for-sap" tabindex="-1">Additional Analysis Configuration for SAP <a class="header-anchor" href="#additional-analysis-configuration-for-sap" aria-label="Permalink to &quot;Additional Analysis Configuration for SAP&quot;">​</a></h2><p>This section describes additional configuration steps required for specific analyses in Teamscale, namely the upload of SAP Code Inspector findings and the usage of coverage results for test gap analysis.</p><h3 id="grouping-changes-by-transport-request-or-task" tabindex="-1">Grouping Changes by Transport Request or Task <a class="header-anchor" href="#grouping-changes-by-transport-request-or-task" aria-label="Permalink to &quot;Grouping Changes by Transport Request or Task&quot;">​</a></h3><p>If your development workflow is centered around transports and tasks, you can use Teamscale to easily group all changes belonging to the same transport into one view. To do that, add a connector or type <em>Issue Tracker</em> &gt; <em>Commit Message Issues</em> in the project creation / edit dialog with the following configuration:</p><ul><li><strong>Issue ID pattern:</strong> <code>Request ([A-Z0-9]{10})[ :]|Task ([A-Z0-9]{10}):</code></li><li><strong>Issue subject pattern:</strong> <code>[^:]+:(.*)</code></li></ul><p>These patterns will extract all requests and tasks. If you are only interested in one of these types, you may remove the other from the Issue ID pattern.</p><p>After project creation or reanalysis, the <em>Activity</em> &gt; <em>Issues</em> view will be populated, and all entries in <em>Activity</em> &gt; <em>Commits</em> will reference the respective request and/or task.</p><h3 id="integrating-sap-code-inspector-atc" tabindex="-1">Integrating SAP Code Inspector / ATC <a class="header-anchor" href="#integrating-sap-code-inspector-atc" aria-label="Permalink to &quot;Integrating SAP Code Inspector / ATC&quot;">​</a></h3><p>Messages resulting from checks of <em>SAP Code Inspector (SCI)</em> can be imported into Teamscale as findings. Thus, all findings management features of Teamscale (e.g., working with baselines, tolerated findings, the definition of tasks, ...) are also available for SCI messages. Once configured, no further manual actions are required by developers to get results of the SCI tests.</p><p>The integration of SAP Code Inspector findings in Teamscale requires that an appropriate Code Inspector variant is defined in the SAP system and that the SAP system connection settings and the project configuration in Teamscale are set up accordingly.</p><p>Teamscale supports findings from SAP Code Inspector and from its addons <code>Code Pal for ABAP</code> and <code>Code Vulnerability Analyzer</code> (<code>CVA</code>). To get findings from these addons, they must be installed in the SAP system (CVA might require an additional license) and enabled in the Code Inspector variant. <a href="https://github.com/SAP/code-pal-for-abap/blob/master/pages/how-to-install.md" target="_blank" rel="noreferrer">Installation Instructions for Code Pal</a> and <a href="https://pages.community.sap.com/topics/abap-testing-analysis/code-vulnerability-analyzer" target="_blank" rel="noreferrer">SAP documentation for CVA</a></p><h3 id="selecting-defining-a-code-inspector-check-variant" tabindex="-1">Selecting/Defining a Code Inspector Check Variant <a class="header-anchor" href="#selecting-defining-a-code-inspector-check-variant" aria-label="Permalink to &quot;Selecting/Defining a Code Inspector Check Variant&quot;">​</a></h3><p>In order to specify which checks should be executed, SAP Code Inspector / ATC uses <em>variants</em>. For Teamscale integration, you can use an existing variant (e.g. the <code>DEFAULT</code> variant that comes pre-configured in every SAP system) or define a custom one based on your coding guidelines. Checks that produce a high amount of irrelevant messages should be excluded, otherwise the storage and backup size of Teamscale could increase heavily. Further, the execution time of some Code Inspector checks might be long, especially if the whole custom code base is checked. If the execution time is too long, we recommend switching off irrelevant checks. Variants can be created or modified in the SAP system using transaction <code>SCI</code>. You should consider using a public variant, as these can be made transportable and therefore be transported to other systems in your organization.</p><div class="info custom-block"><p class="custom-block-title">INFO</p><p>For findings to appear in Teamscale, the checks you enable in the Code Inspector variant also have to be enabled in Teamscale&#39;s analysis profile. Code Inspector messages for checks unknown to Teamscale or disabled in the analysis profile will be logged as warnings in the worker log.</p></div><h3 id="code-inspector-settings-in-sap-abap-system-connection" tabindex="-1">Code Inspector Settings in SAP ABAP System Connection <a class="header-anchor" href="#code-inspector-settings-in-sap-abap-system-connection" aria-label="Permalink to &quot;Code Inspector Settings in SAP ABAP System Connection&quot;">​</a></h3><h4 id="parameters-for-sap-code-inspector-execution-during-code-retrieval" tabindex="-1">Parameters for SAP Code Inspector Execution during Code Retrieval <a class="header-anchor" href="#parameters-for-sap-code-inspector-execution-during-code-retrieval" aria-label="Permalink to &quot;Parameters for SAP Code Inspector Execution during Code Retrieval&quot;">​</a></h4><table><tbody><tr><td><strong>Code Inspector: variant name</strong></td><td>Name of an SAP Code Inspector variant which should be executed</td></tr><tr><td><strong>Code Inspector: variant user</strong></td><td> Specifies the SAP username of the variant owner (leave empty for public variants).</td></tr><tr><td><strong>Code Inspector: include specification</strong></td><td>Defines for which code objects Code Inspector should be executed.</td></tr><tr><td><strong>Code Inspector: exclude specification</strong></td><td>Defines exclusions of code objects for Code Inspector execution.</td></tr></tbody></table><p>To execute SAP Code Inspector during code retrieval of Teamscale, this must be configured under <em>Admin</em> &gt; <em>Settings</em> &gt; <em>SAP ABAP System Connection</em> (see table above). The name of the executed Code Inspector variant must be specified in parameter <em>Name of the SAP Code Inspector variant</em>. If this is not a public variant, but a user variant, the SAP username of the owner must be additionally specified in the parameter <em>Name of the owner of the SAP Code Inspector variant</em>.</p><p>The parameters <em>Code Inspector include specification</em> and <em>Code Inspector exclude specification</em> are used to restrict the code that is checked by SAP Code Inspector. These includes/excludes are stated as a list of Ant patterns matching against the file paths of the ABAP source code objects as visible in Teamscale, this is similar to the patterns used for project configuration.</p><p>Note that the single star wild card (<code>*</code>, which matches a sequence of chars but not <code>/</code>) cannot be used in these patterns.</p><p>With this configuration, Code Inspector is executed in the SAP system during every code retrieval. During change polling, only changed ABAP repository objects are checked by SAP Code Inspector, but during the full synchronization, Code Inspector is executed for all ABAP repository objects in the specified namespaces. As the full synchronization may take a long time (up to a few hours for code bases of many million lines of code), we recommend to schedule the full synchronization at most once every night.</p><div class="warning custom-block"><p class="custom-block-title">Potential memory bottlenecks with Extended Program Check (SLIN) inspections</p><p>Please note that the SAP Code Inspector inspections in <em>Extended Program Check (SLIN)</em> use internal caching to store and reuse test results. If these inspections are activated in a Code Inspector variant, memory bottlenecks may be caused in case of very large ABAP programs that lead to failing (full) exports. A prominent example of a very long program (with more than 120k LOC) is the standalone version of the <a href="https://raw.githubusercontent.com/abapGit/build/main/zabapgit_standalone.prog.abap" target="_blank" rel="noreferrer">AbapGit report</a>. If included in the codebase, we recommend to exclude this report from SAP Code Inspector executions by using the following pattern in the <em>Code Inspector exclude specification</em>: <code>**/PROG/*zabapgit*.abap</code>.</p></div><h4 id="code-inspector-settings-in-project-configuration" tabindex="-1">Code Inspector Settings in Project Configuration <a class="header-anchor" href="#code-inspector-settings-in-project-configuration" aria-label="Permalink to &quot;Code Inspector Settings in Project Configuration&quot;">​</a></h4><p>To actually include findings from SAP Code Inspector in a Teamscale project, the following must be configured:</p><ul><li>In the analysis profile, <em>Code Inspector</em> must be enabled as an analysis tool.</li><li>Under the <em>expert options</em> of the ABAP connector, the <em>Analysis report mapping</em> rule <code>**.sci -&gt; SAP_CODE_INSPECTOR</code> must be specified (Note: by default, it is).</li></ul><p>If the above is correctly configured, findings from SAP Code Inspector should be visible in Teamscale just like other findings and are updated simultaneously with every code change. Note that during change polling, only changed repository objects are analyzed by SAP Code Inspector. New findings from Code Inspector which affect unchanged objects will only be visible after the next full synchronization.</p><h3 id="test-gap-analysis-set-up-for-sap" tabindex="-1">Test Gap Analysis Set Up For SAP <a class="header-anchor" href="#test-gap-analysis-set-up-for-sap" aria-label="Permalink to &quot;Test Gap Analysis Set Up For SAP&quot;">​</a></h3><p>To perform test gap analysis, it is required that the SAP Coverage Analyzer (SCOV) is collecting coverage data from (test) executions. Depending on the actual system, either SCOV Lite (if available) or the regular SCOV has to be used as coverage analyzer. Teamscale will use SCOV Lite automatically, if the Teamscale user has the <code>S_COV_ADM</code> authorization object. SCOV Lite is the preferred method, as it has a smaller performance impact. If you want to use the regular SCOV, it is necessary to activate SCOV manually for every system.</p><h4 id="manually-activating-scov" tabindex="-1">Manually Activating SCOV <a class="header-anchor" href="#manually-activating-scov" aria-label="Permalink to &quot;Manually Activating SCOV&quot;">​</a></h4><p>This section describes how to manually activate the regular SCOV. Please make sure to check whether this is necessary for you.</p><div class="warning custom-block"><p class="custom-block-title">User Rights of Processes</p><p>This will schedule the batch job <code>RSCVR_TRIGGER_COLLECT</code> to run every 45 minutes. By default, SAP NetWeaver configures this job to be executed by the user that activates SCOV. We suggest to edit this batch job and use a technical user instead in order to be independent of personal account availability and permissions.</p><p>Note that background jobs in SAP are always scheduled in the system time zone and do not respect the user time zone. Thus, errors may occur during SCOV activation if the user who activates SCOV has a different user time zone setting. The user time zone can be checked/modified in transaction <code>SU01</code>. It is recommended that a user with no specific user time zone setting performs the activation.</p></div><p>The coverage analyzer is configured via the transaction <code>SCOV</code> . Here it is important that both the coverage analyzer and the data collection for the server are activated. A detailed description of the activation can be found at <a href="https://help.sap.com/saphelp_nw74/helpdata/en/49/21872b4ab514cde10000000a42189b/frameset.htm?frameset=/en/fa/9ad6b2bcb64a18a13ef4bc35c1be16/frameset.htm&amp;current_toc=/en/64/d255cb986147f3a7bad0a000d88174/plain.htm&amp;node_id=113&amp;show_children=false" target="_blank" rel="noreferrer"><code>http://help.sap.com/</code></a>. No specific settings (e.g., test groups) need to be configured. This image shows the required configuration, the important parts are highlighted:</p><p><img src="`+r+'" alt="SCOV Activation" width="1017" height="413" data-zoom="true"></p><h4 id="ensuring-scov-is-active" tabindex="-1">Ensuring SCOV is Active <a class="header-anchor" href="#ensuring-scov-is-active" aria-label="Permalink to &quot;Ensuring SCOV is Active&quot;">​</a></h4><p>In order to make sure SCOV is functional and records data as expected, the start screen of transaction <code>SCOV</code> can be checked. Please ensure the following:</p><ul><li>The <em>General Status</em> area has a green indicator next to <em>Main Switch</em>.</li><li>The <em>Status of Current Application Server</em> area has a green indicator next to <em>Data Collectn</em>.</li><li>The <em>Messages</em> area does not show errors.</li><li>The <em>Last Data Collection</em> is less than 45 minutes ago.</li></ul><p><img src="'+c+'" alt="SCOV Activation Check" width="346" height="332"></p><h3 id="troubleshooting-no-coverage-information" tabindex="-1">Troubleshooting: No Coverage Information <a class="header-anchor" href="#troubleshooting-no-coverage-information" aria-label="Permalink to &quot;Troubleshooting: No Coverage Information&quot;">​</a></h3><p>If the results do not look as expected, most of the time it is enough to use the repair functionality that is included in SAP Coverage Analyzer. Execute transaction <code>SCOV</code> and run the consistency checks with repair option:</p><p><img src="'+d+'" alt="Image: sap-scov-repair" width="843" height="288" data-zoom="true"></p><p>Afterwards, you can check the <em>Monitor</em> view for errors. If there are old errors, which are obsolete after the repair, these can be cleared by selecting a line and clicking <em>Completed</em> as shown here:</p><p><img src="'+l+'" alt="Image: sap-scov-monitor" width="1031" height="261" data-zoom="true"></p><p>In case of problems with the batch job <code>RSCVR_TRIGGER_COLLECT</code>, please make sure the user configured for the job does still exist and is not locked.</p><h3 id="using-scov-lite-for-teamscale-and-upl" tabindex="-1">Using SCOV Lite for Teamscale and UPL <a class="header-anchor" href="#using-scov-lite-for-teamscale-and-upl" aria-label="Permalink to &quot;Using SCOV Lite for Teamscale and UPL&quot;">​</a></h3><p>If you would like to use Teamscale to analyze coverage information from a system that is already using Usage Procedure Logging (UPL), there are a few things to consider. Otherwise, these tools may interfere with each other and produce incorrect results. In essence, both the coverage-enabled Teamscale export and UPL use the same raw data created by SCOV Lite in the system table <code>COVRES</code>. However, when UPL extracts that data via the batch job <code>/SDF/UPL_PERIODIC_EXT_JOB</code> every 24 hours, it empties that table, whereas the Teamscale Connector does not.</p><p>This means the Teamscale export should run briefly before the UPL extraction job. In order to find out when that job is scheduled, you can either use transaction <code>SM37</code> in the SAP system or have a look at the file <code>job_status.csv</code> in one of the exported zip files. Afterwards, adjust the polling schedule for coverage data in your SAP System Connection to run a few minutes before that time. You may still have multiple updates per day, as long as one of them always runs shortly before the UPL extraction job.</p><h2 id="integration-with-abap-development-tools-for-eclipse-adt" tabindex="-1">Integration with ABAP Development Tools for Eclipse (ADT) <a class="header-anchor" href="#integration-with-abap-development-tools-for-eclipse-adt" aria-label="Permalink to &quot;Integration with ABAP Development Tools for Eclipse (ADT)&quot;">​</a></h2><p>Teamscale analyses can be integrated into Eclipse-based development workflows, displaying findings directly in the IDE. Thus, users will get most of the relevant information in their usual development environment, not needing to switch to Teamscale&#39;s web interface.</p><p>For installation and configuration of the Eclipse plugin, please <a href="./../../getting-started/eclipse/">see this guide</a>.</p><h2 id="integration-with-atc" tabindex="-1">Integration with ATC <a class="header-anchor" href="#integration-with-atc" aria-label="Permalink to &quot;Integration with ATC&quot;">​</a></h2><p>Teamscale findings can be also shown within classical SAP development tools like ABAP Test Cockpit (ATC) and SAP Code Inspector (SCI). Thus, Teamscale findings can be handled within the ABAP Workbench in the same way as any other Code Inspector messages, e.g. by using the check functions available in <code>SE80</code>.</p><p>To achieve this, the Teamscale Connector for SAP NetWeaver® AS ABAP® contains an implementation of a custom SAP Code Inspector test which allows to retrieve findings from Teamscale. To be able to execute the respective Code Inspector test <em>Teamscale Findings</em>, the following configuration steps are required.</p><h3 id="configuring-https-connection-to-teamscale" tabindex="-1">Configuring HTTPS Connection to Teamscale <a class="header-anchor" href="#configuring-https-connection-to-teamscale" aria-label="Permalink to &quot;Configuring HTTPS Connection to Teamscale&quot;">​</a></h3><p>If Teamscale is accessible via HTTPS (see section <a href="./../../howto/configuring-https/">Configuring HTTPS</a>), some configuration steps might be necessary in the SAP system.</p><div class="info custom-block"><p class="custom-block-title">General HTTPS configuration</p><p>This section assumes that your SAP system is already configured to establish HTTPS connections, and focuses on importing the correct root certificate only. For a more detailed description of general prerequisites, cipher suite settings, or how to obtain the root certificate, please refer to the <a href="https://docs.abapgit.org/user-guide/setup/ssl-setup.html" target="_blank" rel="noreferrer"><em>SSL Setup</em> section of the abapGit documentation</a>. It covers all these topics, and is not specific to abapGit for most of them.</p></div><p>In order to check whether your SAP system can already connect to Teamscale, you may download and use the report <a href="https://docs.abapgit.org/user-guide/setup/ssl-test.html" target="_blank" rel="noreferrer">zabapgit_test_ssl</a>. Just enter the Teamscale server&#39;s URL into the <em>URL</em> field. You can ignore the fact that it refers to <em>Git server</em>, it works just fine with any other HTTPS URL. If the report shows <code>ok</code>, no further steps are necessary. In case the output mentions <code>SSSLERR_PEER_CERT_UNTRUSTED</code>, a required root certificate is likely missing.</p><h4 id="importing-tls-root-certificates" tabindex="-1">Importing TLS Root Certificates <a class="header-anchor" href="#importing-tls-root-certificates" aria-label="Permalink to &quot;Importing TLS Root Certificates&quot;">​</a></h4><div class="warning custom-block"><p class="custom-block-title">Only import the CA Root Certificate</p><p>HTTPS server certificates are relatively short-lived and therefore re-issued frequently. In order to connect to an HTTPS server like Teamscale, you only need to explicitly add the Certificate Authority&#39;s (much longer-lived) <em>root certificate</em> to your SAP system&#39;s trust store. Importing individual server certificates is <em>not</em> required.</p></div><p>To import the root certificate, perform the following steps in transaction <code>STRUST</code>:</p><ol><li>Enter edit mode using the <em>Display &lt;-&gt; Change</em> button.</li><li>Select <em>SSL client SSL Client (Anonymous)</em> on the left.</li><li>In the <em>Certificate</em> section, click on the bottom-left button <em>Import certificate</em>.</li><li>Choose the root certificate to import into the system.</li><li>Select <em>Add to certificate list</em>.</li><li>Save.</li></ol><h4 id="cipher-suite-configuration" tabindex="-1">Cipher Suite Configuration <a class="header-anchor" href="#cipher-suite-configuration" aria-label="Permalink to &quot;Cipher Suite Configuration&quot;">​</a></h4><p>If your Teamscale server has restrictions with respect to accepted TLS ciphers, you may need some additional modifications. For example, if only TLSv1.2 with perfect forward security (ECDHE ciphers) is allowed, on some SAP systems you may need to enable this with profile parameters in the SAP system first:</p><ol><li>Use transaction <code>RZ10</code>, select the <em>DEFAULT</em> profile and <em>extended maintenance</em> &gt; <em>change</em>.</li><li>Create or modify the parameter <code>ssl/client_ciphersuites</code> and set it to <code>908:PFS:HIGH:MEDIUM:+e3DES</code>.</li><li>Save and activate the changed profile (respective dialogs will appear).</li><li>Restart the SAP application server.</li></ol><p>Further information can be found in <a href="https://archive.sap.com/discussions/thread/3751351" target="_blank" rel="noreferrer">the SAP Community</a>.</p><h3 id="configuring-connection-settings" tabindex="-1">Configuring Connection Settings <a class="header-anchor" href="#configuring-connection-settings" aria-label="Permalink to &quot;Configuring Connection Settings&quot;">​</a></h3><p>The Code Inspector test <em>Teamscale Findings</em> has to authenticate with the Teamscale server to retrieve findings. Also, it can use an HTTP(s) proxy. Depending on the version, the configuration differs.</p><p>Version v2503 and earlier use the global HTTP(s) client settings defined in your system, including the proxy defined there. If your SAP System requires an HTTP(S) proxy in order to connect to the Teamscale server, please make sure the system&#39;s global proxy settings in <code>SM59</code> &gt; <em>Extras</em> &gt; <em>HTTP Proxy Configuration</em> (<em>»Shift+F1«</em>) are configured accordingly. The relevant settings are on the <em>Global Settings</em> and <em>HTTPS Protocol</em> tabs. The URL to the Teamscale server as well as authentication and timeout settings are configured in the check parameters (see <a href="#teamscale-findings-parameters">Teamscale Findings Parameters</a>).</p><p>Starting with v2506, connection settings are configured via an HTTP destination created in transaction <code>SM59</code>. See <a href="https://help.sap.com/docs/ABAP_PLATFORM_NEW/753088fc00704d0a80e7fbd6803c8adb/48d7ad896b57154ee10000000a421937.html?locale=en-US" target="_blank" rel="noreferrer">SAP Help</a> for how to create HTTP destinations. There, you can configure a connection-specific HTTP(S) proxy, timeout value, HTTP version etc. For <em>authentication</em>, you must use <code>Basic Authentication</code> with a valid Teamscale username and the respective <a href="./../../glossary/#access-key">Access Key</a>.</p><h3 id="test-activation" tabindex="-1">Test Activation <a class="header-anchor" href="#test-activation" aria-label="Permalink to &quot;Test Activation&quot;">​</a></h3><p>First, Code Inspector test <em>Teamscale Findings</em> must be activated:</p><ol><li>In transaction <code>SCI</code>, select the action <em>Code Inspector</em> &gt; <em>Management of</em> &gt; <em>Tests</em> (or <em>»Ctrl+Alt+F5«</em>).</li><li>Mark the checkboxes at the check classes <code>/CQSE/CL_CI_CATEGORY_TEAMSCALE</code> (category for Teamscale) and <code>/CQSE/CL_CI_TEST_TS_FINDINGS</code> (Teamscale findings test).</li><li>Save your changes.</li></ol><h3 id="definition-of-a-check-variant" tabindex="-1">Definition of a Check Variant <a class="header-anchor" href="#definition-of-a-check-variant" aria-label="Permalink to &quot;Definition of a Check Variant&quot;">​</a></h3><p>Second, a check variant which contains the <em>Teamscale Findings</em> test must be defined. In transaction <code>SCI</code>, add a new check variant and select the <em>Teamscale Findings</em> test:</p><p><img src="'+h+'" alt="Teamscale Findings SCI Test" width="676" height="835" data-zoom="true"></p><p>Also, the required parameters of this test must be specified:</p><h4 id="teamscale-findings-parameters" tabindex="-1">Teamscale Findings Parameters <a class="header-anchor" href="#teamscale-findings-parameters" aria-label="Permalink to &quot;Teamscale Findings Parameters&quot;">​</a></h4><p>There are several groups of parameters to define how to retrieve Teamscale findings and which ones to show: <em>Connection parameters</em> define how to connect to Teamscale, <em>Baseline parameters</em> define which time period to retrieve findings for, and <em>Quality goal parameters</em> reflect whether only new findings should cause messages, or also old findings in recently changed code.</p><div class="info custom-block"><p class="custom-block-title">Connection Parameters are version-dependent.</p><p>In Teamscale Connector for SAP NetWeaver® AS ABAP® versions until v2503, all connection parameters are either defined by system defaults (like proxy settings) or configured directly in the check. Newer versions use <code>SM59</code> destinations to configure the connection to Teamscale. See <a href="#configuring-connection-settings">Configuring Connection Settings</a> for details.</p></div><p><img src="'+p+'" alt="Teamscale Findings Parameters v2506" width="1449" height="928" data-zoom="true"></p><table><tbody><tr><td><strong>SM59 HTTP Destination name</strong><br>(v2506 and later)</td><td> An HTTP destination (type <code>G</code>) created in transaction <code>SM59</code>. See <a href="#configuring-connection-settings">Configuring Connection Settings</a> for details. </td></tr><tr><td><strong>Teamscale server URL</strong><br>(v2503 and earlier)</td><td>URL of the Teamscale instance</td></tr><tr><td><strong>Teamscale user name</strong><br>(v2503 and earlier)</td><td>Name of the Teamscale user which should be used to retrieve the findings</td></tr><tr><td><strong>User&#39;s access key</strong><br>(v2503 and earlier)</td><td>The <a href="../../glossary/#access-key">access key</a> of this user (must be generated in the user preferences of the Teamscale Web UI)</td></tr><tr><td><strong>Timeout (in s) for updating findings</strong><br>(v2503 and earlier)</td><td>Timeout after which the check raises a timeout message.</td></tr><tr><td><strong>Teamscale project id</strong></td><td>The identifier of the project in Teamscale for which findings should be retrieved. If no project ID is provided, the check will query Teamscale for projects that are associated with the respective system ID.</td></tr><tr><td><strong>Only new findings since (label)</strong></td><td>Optional. If set, only findings which were introduced after the given baseline label are included. Baselines are managed in the Teamscale Web UI under <em>Quality Control &gt; Baselines</em>)</td></tr><tr><td><strong>Only new findings since (date)</strong></td><td>Optional. If set, only findings introduced after the specified date are included.</td></tr><tr><td><strong>Also finds. in changed code</strong></td><td>If enabled and also one of the <em>Only new findings since</em> parameters or <em>Filter old transport findings</em> is set, not only new findings but also findings in code changed since the baseline are included</td></tr><tr><td><strong>Filter old transport findings</strong></td><td>If enabled, only findings that were introduced in a still-open transport request will be included. This setting should only be active in check variants used for ATC checks on transport release. Note that the creation date of the oldest relevant transport request is used.</td></tr></tbody></table><div class="info custom-block"><p class="custom-block-title">Baseline parameters are mutually exclusive</p><p>The three check parameters <em>Only new findings since (label)</em>, <em>Only new findings since (date)</em>, and <em>Filter old transport findings</em> all affect to which degree old findings should be returned. In order to have consistent information in all cases, only one of these parameters may be used. If you need different baseline settings for different use cases, e.g. one for on-demand checks and one for check on transport release, different check variants must be used.</p></div><h3 id="execute-the-check-variant" tabindex="-1">Execute the Check Variant. <a class="header-anchor" href="#execute-the-check-variant" aria-label="Permalink to &quot;Execute the Check Variant.&quot;">​</a></h3><p>After the variant is saved, it can be executed like any other Code Inspector variant, e.g. by transaction <code>SCI</code> or from the ABAP Workbench (<code>SE80</code>) using the commands <em>Check</em> &gt; <em>Code Inspector</em> or <em>Check</em> &gt; <em>ABAP Test Cockpit (ATC)</em>. Note that you must edit the <code>DEFAULT</code> variant if the <em>Teamscale findings</em> test should be executed when running these <em>Check</em> commands, unless you use command <em>ABAP Test Cockpit (ATC) with ...</em>.</p><p>The results are displayed in the ATC results browser:</p><p><img src="'+m+'" alt="sap-sci-results" width="960" height="791" data-zoom="true"></p><p>By clicking on the info button at the single messages (leaves in the tree), the <em>Findings Details</em> view of the Teamscale web UI opens, where e.g. more information of the finding can be viewed. Here, the finding can be assigned to a task or tolerated or marked as false positive finding. (Note that the info buttons at other nodes than the leaves are without any meaningful function.)</p><h2 id="integration-with-sap-transport-management-system" tabindex="-1">Integration with SAP Transport Management System <a class="header-anchor" href="#integration-with-sap-transport-management-system" aria-label="Permalink to &quot;Integration with SAP Transport Management System&quot;">​</a></h2><p>As described in the section above, the SAP Code Inspector test <em>Teamscale Findings</em> allows to retrieve findings from Teamscale and display these in the SAP system. Thus, Teamscale findings can be used in the SAP Transport Management System (TMS) like any other ATC checks. The prerequisites for this are the same as for regular ATC integration, so please make sure to follow the instructions above.</p><p>Depending on you SAP release and patch level, different options may be available for configuring ATC runs on transport release or task release.</p><div class="info custom-block"><p class="custom-block-title">SAP Note for check on task release</p><p>In case one of ATC configuration options is not available in your system (in particular the option to execute checks on <em>task release</em>), please check <a href="https://me.sap.com/notes/2495410" target="_blank" rel="noreferrer">SAP Note 2495410</a> (login required), which enables the respective functionality on older systems.</p></div><p>To enable the ATC check on transport release, the following configuration is required:</p><ol><li>Define a Code Inspector variant which executes the test <em>Teamscale Findings</em> (see previous section).</li><li>Ensure that checks on request release are globally activated: Transaction <code>SE03</code> (<em>Transport Organizer Tools</em>), item <em>Administration</em> &gt; <em>Global Customizing</em>, setting for <em>Check Objects when Request Released</em>. <img src="'+u+'" alt="SAP Transport Integration - SE03" width="610" height="398" data-zoom="true"></li><li>In transaction <code>ATC</code>, under <em>ATC Administration</em> &gt; <em>Setup</em> &gt; <em>Configure ATC</em>, configure the respective Code Inspector variant and the setting <em>ATC: Behavior on Release</em>. Choose <em>Inform on Errors</em> (recommended) or <em>Block on Errors</em>. <img src="'+f+'" alt="SAP Transport Integration - ATC" width="735" height="258" data-zoom="true"></li><li>Save.</li></ol><div class="info custom-block"><p class="custom-block-title">SAP Note to only consider changed sub-objects</p><p>In order to best follow the <a href="./../../introduction/improving-software-quality/#improving-code-quality-using-quality-goals">campsite rule</a>, we suggest implementing <a href="https://me.sap.com/notes/3392749" target="_blank" rel="noreferrer">SAP Note 3392749</a> (login required). This adds the option <em>Restrict Findings to Objects on Transports</em> to the ATC settings. Without it, if one method of a class was changed, ATC will report findings for all other method includes (changed or unchanged) as well.</p></div><p>When releasing a transport request or task, depending on your configuration, the check variant will be executed, query Teamscale findings, and display them or block the release. In case individual findings should not block the release, we recommend using Teamscale&#39;s <a href="./../../reference/ui/findings/#marking-findings-as-tolerated-or-false-positive">toleration feature</a>.</p><p><img src="'+g+'" alt="SAP Transport Integration - Findings" width="606" height="281" data-zoom="true"></p><h2 id="teamscale-features-for-sap-abap" tabindex="-1">Teamscale Features for SAP ABAP <a class="header-anchor" href="#teamscale-features-for-sap-abap" aria-label="Permalink to &quot;Teamscale Features for SAP ABAP&quot;">​</a></h2><h3 id="properties-of-abap-code-objects" tabindex="-1">Properties of ABAP Code Objects <a class="header-anchor" href="#properties-of-abap-code-objects" aria-label="Permalink to &quot;Properties of ABAP Code Objects&quot;">​</a></h3><p>On SAP systems, developers are able to view various information about code objects. However, doing so requires considerable efforts in knowing</p><ul><li>in which database tables they are stored and formulating SQL queries to retrieve them; or</li><li>which user interfaces display them; or</li><li>which APIs are utilized internally to retrieve them.</li></ul><p>Teamscale saves ABAP developers these efforts by retrieving the information. A user can later see them on the Code view by clicking <em>Actions</em> &gt; <em>Abap object properties</em>.</p><p><img src="'+b+'" alt="ABAP Object Basic Infos" width="1585" height="915" data-zoom="true"></p><p><img src="'+y+'" alt="ABAP Object Release Contract" width="1152" height="997" data-zoom="true"></p><h2 id="git-based-abap-development-gcts-abapgit" tabindex="-1">Git-based ABAP development (gCTS, abapGit) <a class="header-anchor" href="#git-based-abap-development-gcts-abapgit" aria-label="Permalink to &quot;Git-based ABAP development (gCTS, abapGit)&quot;">​</a></h2><p>While using Teamscale with the above-mentioned Teamscale Connector for SAP NetWeaver® AS ABAP® provides the best out-of-the-box experience and the most features, some organizations already use Git-based workflows. For these, the following paragraphs outline how well Teamscale integrates with Git repositories created by abapGit or gCTS.</p><h3 id="abapgit" tabindex="-1">abapGit <a class="header-anchor" href="#abapgit" aria-label="Permalink to &quot;abapGit&quot;">​</a></h3><p>As we use abapGit ourselves to develop in ABAP, we make sure that Teamscale supports analyzing Git repositories created with <a href="https://abapgit.org/" target="_blank" rel="noreferrer">abapGit</a>. Depending on the particular Git hosting platform you use, please use the respective <a href="./../../reference/supported-technologies/version-control-systems/">repository connector</a> and enjoy full support for features like pull request integration.</p><h3 id="git-based-cts-gcts" tabindex="-1">Git-based CTS (gCTS) <a class="header-anchor" href="#git-based-cts-gcts" aria-label="Permalink to &quot;Git-based CTS (gCTS)&quot;">​</a></h3><p>Although technically, gCTS repositories are Git repositories, they are not suited for code analysis. Therefore, we do not recommend connecting Teamscale to a gCTS repository unless SAP implements the <a href="https://github.com/SAP/abap-file-formats" target="_blank" rel="noreferrer">ABAP File Formats</a> specification in gCTS. Depending on your particular environment, please use one of the following approaches to analyze ABAP code using Teamscale:</p><ul><li><strong>SAP NetWeaver AS ABAP:</strong> <a href="#teamscale-connector-for-sap-netweaver®-as-abap®">Teamscale Connector for SAP NetWeaver® AS ABAP®</a></li><li><strong>SAP Cloud ERP Private:</strong> <a href="#teamscale-connector-for-sap-netweaver®-as-abap®">Teamscale Connector for SAP NetWeaver® AS ABAP®</a>.</li><li><strong>SAP Cloud ERP:</strong> <a href="#abapgit">abapGit</a>.</li><li><strong>SAP BTP ABAP Environment:</strong> <a href="#abapgit">abapGit</a>.</li></ul>',210)])])}const q=t(A,[["render",S]]);export{I as __pageData,q as default};
